/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.auth;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.inlong.manager.common.auth.Authentication;
import org.apache.inlong.manager.common.util.AssertUtils;

public class DefaultAuthentication
implements Authentication {
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    protected String userName;
    protected String password;

    public DefaultAuthentication(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    @Override
    public Authentication.AuthType getAuthType() {
        return Authentication.AuthType.UNAME_PASSWD;
    }

    @Override
    public void configure(Map<String, String> properties) {
        AssertUtils.notEmpty(properties, "Properties should not be empty when init DefaultAuthentication");
        this.userName = properties.get(USERNAME);
        this.password = properties.get(PASSWORD);
    }

    public String toString() {
        ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
        objectNode.put(USERNAME, this.getUserName());
        objectNode.put(PASSWORD, this.getPassword());
        return objectNode.toString();
    }

    public DefaultAuthentication() {
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }
}

