/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.auth;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.inlong.manager.common.auth.Authentication;
import org.apache.inlong.manager.common.util.AssertUtils;

public class SecretAuthentication
implements Authentication {
    public static final String SECRET_ID = "secret_id";
    public static final String SECRET_KEY = "secret_key";
    protected String secretId;
    protected String secretKey;

    public SecretAuthentication(String secretId, String secretKey) {
        this.secretId = secretId;
        this.secretKey = secretKey;
    }

    @Override
    public Authentication.AuthType getAuthType() {
        return Authentication.AuthType.SECRET;
    }

    @Override
    public void configure(Map<String, String> properties) {
        AssertUtils.notEmpty(properties, "Properties should not be empty when init SecretAuthentication");
        this.secretId = properties.get(SECRET_ID);
        this.secretKey = properties.get(SECRET_KEY);
    }

    public String toString() {
        ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
        objectNode.put(SECRET_ID, this.getSecretId());
        objectNode.put(SECRET_KEY, this.getSecretKey());
        return objectNode.toString();
    }

    public SecretAuthentication() {
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }
}

