/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;

public enum ClusterType {
    TUBE,
    PULSAR,
    DATA_PROXY;

    public static final String CLS_TUBE = "TUBE";
    public static final String CLS_PULSAR = "PULSAR";
    public static final String CLS_DATA_PROXY = "DATA_PROXY";

    public static ClusterType forType(String type) {
        for (ClusterType clsType : ClusterType.values()) {
            if (!clsType.name().equals(type)) continue;
            return clsType;
        }
        throw new BusinessException(String.format(ErrorCodeEnum.MQ_TYPE_NOT_SUPPORTED.getMessage(), type));
    }
}

