/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;

public enum GroupMode {
    NORMAL("normal"),
    LIGHT("light");

    private final String mode;

    private GroupMode(String mode) {
        this.mode = mode;
    }

    public static GroupMode forMode(String mode) {
        for (GroupMode groupMode : GroupMode.values()) {
            if (!groupMode.getMode().equals(mode)) continue;
            return groupMode;
        }
        throw new IllegalArgumentException(String.format("Unsupported group mode=%s", mode));
    }

    public static GroupMode parseGroupMode(InlongGroupInfo groupInfo) {
        if (groupInfo.getLightweight() != null && groupInfo.getLightweight() == 1) {
            return LIGHT;
        }
        return NORMAL;
    }

    public String getMode() {
        return this.mode;
    }
}

