/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;

public enum MQType {
    TUBE("TUBE"),
    PULSAR("PULSAR"),
    TDMQ_PULSAR("TDMQ_PULSAR"),
    NONE("NONE");

    public static final String MQ_TUBE = "TUBE";
    public static final String MQ_PULSAR = "PULSAR";
    public static final String MQ_TDMQ_PULSAR = "TDMQ_PULSAR";
    public static final String MQ_NONE = "NONE";
    private final String type;

    private MQType(String type) {
        this.type = type;
    }

    public static MQType forType(String type) {
        for (MQType mqType : MQType.values()) {
            if (!mqType.getType().equals(type)) continue;
            return mqType;
        }
        throw new BusinessException(String.format(ErrorCodeEnum.MQ_TYPE_NOT_SUPPORTED.getMessage(), type));
    }

    public String getType() {
        return this.type;
    }
}

