/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import java.util.Locale;

public enum SinkType {
    HIVE,
    KAFKA,
    ICEBERG,
    CLICKHOUSE,
    HBASE,
    POSTGRES,
    ELASTICSEARCH,
    SQLSERVER,
    HDFS,
    GREENPLUM,
    MYSQL;

    public static final String SINK_HIVE = "HIVE";
    public static final String SINK_KAFKA = "KAFKA";
    public static final String SINK_ICEBERG = "ICEBERG";
    public static final String SINK_CLICKHOUSE = "CLICKHOUSE";
    public static final String SINK_HBASE = "HBASE";
    public static final String SINK_POSTGRES = "POSTGRES";
    public static final String SINK_ELASTICSEARCH = "ELASTICSEARCH";
    public static final String SINK_SQLSERVER = "SQLSERVER";
    public static final String SINK_HDFS = "HDFS";
    public static final String SINK_GREENPLUM = "GREENPLUM";
    public static final String SINK_MYSQL = "MYSQL";

    public static SinkType forType(String sinkType) {
        for (SinkType type : SinkType.values()) {
            if (!type.name().equals(sinkType)) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format("Illegal sink type for %s", sinkType));
    }

    public String toString() {
        return this.name().toUpperCase(Locale.ROOT);
    }
}

