/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

import java.util.Locale;
import org.apache.inlong.common.enums.TaskTypeEnum;

public enum SourceType {
    AUTO_PUSH("AUTO_PUSH", null),
    FILE("FILE", TaskTypeEnum.FILE),
    SQL("SQL", TaskTypeEnum.SQL),
    BINLOG("BINLOG", TaskTypeEnum.BINLOG),
    KAFKA("KAFKA", TaskTypeEnum.KAFKA),
    PULSAR("PULSAR", TaskTypeEnum.PULSAR),
    POSTGRES("POSTGRES", TaskTypeEnum.POSTGRES),
    ORACLE("ORACLE", TaskTypeEnum.ORACLE),
    SQLSERVER("SQLSERVER", TaskTypeEnum.SQLSERVER),
    MONGODB("MONGO", TaskTypeEnum.MONGODB);

    public static final String SOURCE_AUTO_PUSH = "AUTO_PUSH";
    public static final String SOURCE_FILE = "FILE";
    public static final String SOURCE_SQL = "SQL";
    public static final String SOURCE_BINLOG = "BINLOG";
    public static final String SOURCE_KAFKA = "KAFKA";
    public static final String SOURCE_PULSAR = "PULSAR";
    public static final String SOURCE_POSTGRES = "POSTGRES";
    public static final String SOURCE_ORACLE = "ORACLE";
    public static final String SOURCE_SQLSERVER = "SQLSERVER";
    public static final String SOURCE_MONGODB = "MONGODB";
    private final String type;
    private final TaskTypeEnum taskType;

    private SourceType(String type, TaskTypeEnum taskType) {
        this.type = type;
        this.taskType = taskType;
    }

    public static SourceType forType(String sourceType) {
        for (SourceType type : SourceType.values()) {
            if (!type.getType().equals(sourceType)) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format("Illegal sink type for %s", sourceType));
    }

    public String toString() {
        return this.name().toUpperCase(Locale.ROOT);
    }

    public String getType() {
        return this.type;
    }

    public TaskTypeEnum getTaskType() {
        return this.taskType;
    }
}

