/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

public enum StreamStatus {
    DRAFT(0, "draft"),
    NEW(100, "new"),
    CONFIG_ING(110, "in configure"),
    CONFIG_FAILED(120, "configuration failed"),
    CONFIG_SUCCESSFUL(130, "configuration successful"),
    SUSPENDING(141, "suspending"),
    SUSPENDED(140, "suspended"),
    RESTARTING(151, "restarting"),
    RESTARTED(150, "restarted"),
    DELETING(41, "deleting"),
    DELETED(40, "deleted");

    private final Integer code;
    private final String description;

    private StreamStatus(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static StreamStatus forCode(int code) {
        for (StreamStatus status : StreamStatus.values()) {
            if (status.getCode() != code) continue;
            return status;
        }
        throw new IllegalStateException(String.format("Illegal code=%s for StreamStatus", code));
    }
}

