/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.cluster;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;

@ApiModel(value="Inlong cluster request")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="type")
public class InlongClusterRequest {
    @ApiModelProperty(value="Primary key")
    private Integer id;
    @NotBlank
    @ApiModelProperty(value="Cluster name")
    private String name;
    @NotBlank
    @ApiModelProperty(value="Cluster type, including TUBE, PULSAR, DATA_PROXY, etc.")
    private String type;
    @ApiModelProperty(value="Cluster url")
    private String url;
    @NotBlank
    @ApiModelProperty(value="Cluster tag")
    private String clusterTag;
    @ApiModelProperty(value="Extension tag")
    private String extTag;
    @ApiModelProperty(value="Cluster token")
    private String token;
    @ApiModelProperty(value="Cluster heartbeat info")
    private String heartbeat;
    @ApiModelProperty(value="Extended params")
    private String extParams;
    @ApiModelProperty(value="Name of responsible person, separated by commas")
    private String inCharges;

    public static InlongClusterRequestBuilder builder() {
        return new InlongClusterRequestBuilder();
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public String getClusterTag() {
        return this.clusterTag;
    }

    public String getExtTag() {
        return this.extTag;
    }

    public String getToken() {
        return this.token;
    }

    public String getHeartbeat() {
        return this.heartbeat;
    }

    public String getExtParams() {
        return this.extParams;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setClusterTag(String clusterTag) {
        this.clusterTag = clusterTag;
    }

    public void setExtTag(String extTag) {
        this.extTag = extTag;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setHeartbeat(String heartbeat) {
        this.heartbeat = heartbeat;
    }

    public void setExtParams(String extParams) {
        this.extParams = extParams;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongClusterRequest)) {
            return false;
        }
        InlongClusterRequest other = (InlongClusterRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$clusterTag = this.getClusterTag();
        String other$clusterTag = other.getClusterTag();
        if (this$clusterTag == null ? other$clusterTag != null : !this$clusterTag.equals(other$clusterTag)) {
            return false;
        }
        String this$extTag = this.getExtTag();
        String other$extTag = other.getExtTag();
        if (this$extTag == null ? other$extTag != null : !this$extTag.equals(other$extTag)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$heartbeat = this.getHeartbeat();
        String other$heartbeat = other.getHeartbeat();
        if (this$heartbeat == null ? other$heartbeat != null : !this$heartbeat.equals(other$heartbeat)) {
            return false;
        }
        String this$extParams = this.getExtParams();
        String other$extParams = other.getExtParams();
        if (this$extParams == null ? other$extParams != null : !this$extParams.equals(other$extParams)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        return !(this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlongClusterRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $clusterTag = this.getClusterTag();
        result = result * 59 + ($clusterTag == null ? 43 : $clusterTag.hashCode());
        String $extTag = this.getExtTag();
        result = result * 59 + ($extTag == null ? 43 : $extTag.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $heartbeat = this.getHeartbeat();
        result = result * 59 + ($heartbeat == null ? 43 : $heartbeat.hashCode());
        String $extParams = this.getExtParams();
        result = result * 59 + ($extParams == null ? 43 : $extParams.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        return result;
    }

    public String toString() {
        return "InlongClusterRequest(id=" + this.getId() + ", name=" + this.getName() + ", type=" + this.getType() + ", url=" + this.getUrl() + ", clusterTag=" + this.getClusterTag() + ", extTag=" + this.getExtTag() + ", token=" + this.getToken() + ", heartbeat=" + this.getHeartbeat() + ", extParams=" + this.getExtParams() + ", inCharges=" + this.getInCharges() + ")";
    }

    public InlongClusterRequest() {
    }

    public InlongClusterRequest(Integer id, String name, String type, String url, String clusterTag, String extTag, String token, String heartbeat, String extParams, String inCharges) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.url = url;
        this.clusterTag = clusterTag;
        this.extTag = extTag;
        this.token = token;
        this.heartbeat = heartbeat;
        this.extParams = extParams;
        this.inCharges = inCharges;
    }

    public static class InlongClusterRequestBuilder {
        private Integer id;
        private String name;
        private String type;
        private String url;
        private String clusterTag;
        private String extTag;
        private String token;
        private String heartbeat;
        private String extParams;
        private String inCharges;

        InlongClusterRequestBuilder() {
        }

        public InlongClusterRequestBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public InlongClusterRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public InlongClusterRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public InlongClusterRequestBuilder url(String url) {
            this.url = url;
            return this;
        }

        public InlongClusterRequestBuilder clusterTag(String clusterTag) {
            this.clusterTag = clusterTag;
            return this;
        }

        public InlongClusterRequestBuilder extTag(String extTag) {
            this.extTag = extTag;
            return this;
        }

        public InlongClusterRequestBuilder token(String token) {
            this.token = token;
            return this;
        }

        public InlongClusterRequestBuilder heartbeat(String heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        public InlongClusterRequestBuilder extParams(String extParams) {
            this.extParams = extParams;
            return this;
        }

        public InlongClusterRequestBuilder inCharges(String inCharges) {
            this.inCharges = inCharges;
            return this;
        }

        public InlongClusterRequest build() {
            return new InlongClusterRequest(this.id, this.name, this.type, this.url, this.clusterTag, this.extTag, this.token, this.heartbeat, this.extParams, this.inCharges);
        }

        public String toString() {
            return "InlongClusterRequest.InlongClusterRequestBuilder(id=" + this.id + ", name=" + this.name + ", type=" + this.type + ", url=" + this.url + ", clusterTag=" + this.clusterTag + ", extTag=" + this.extTag + ", token=" + this.token + ", heartbeat=" + this.heartbeat + ", extParams=" + this.extParams + ", inCharges=" + this.inCharges + ")";
        }
    }
}

