/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.dbcollector;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="db collector task info")
public class DBCollectorTaskInfo {
    @ApiModelProperty(value="version")
    private String version;
    @ApiModelProperty(value="return code")
    private int returnCode;
    @ApiModelProperty(value="md5")
    private String md5;
    @ApiModelProperty(value="task info detail")
    private TaskInfo data;

    DBCollectorTaskInfo(String version, int returnCode, String md5, TaskInfo data) {
        this.version = version;
        this.returnCode = returnCode;
        this.md5 = md5;
        this.data = data;
    }

    public static DBCollectorTaskInfoBuilder builder() {
        return new DBCollectorTaskInfoBuilder();
    }

    public String getVersion() {
        return this.version;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getMd5() {
        return this.md5;
    }

    public TaskInfo getData() {
        return this.data;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public void setData(TaskInfo data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DBCollectorTaskInfo)) {
            return false;
        }
        DBCollectorTaskInfo other = (DBCollectorTaskInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReturnCode() != other.getReturnCode()) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$md5 = this.getMd5();
        String other$md5 = other.getMd5();
        if (this$md5 == null ? other$md5 != null : !this$md5.equals(other$md5)) {
            return false;
        }
        TaskInfo this$data = this.getData();
        TaskInfo other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DBCollectorTaskInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReturnCode();
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $md5 = this.getMd5();
        result = result * 59 + ($md5 == null ? 43 : $md5.hashCode());
        TaskInfo $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "DBCollectorTaskInfo(version=" + this.getVersion() + ", returnCode=" + this.getReturnCode() + ", md5=" + this.getMd5() + ", data=" + this.getData() + ")";
    }

    public static class DBCollectorTaskInfoBuilder {
        private String version;
        private int returnCode;
        private String md5;
        private TaskInfo data;

        DBCollectorTaskInfoBuilder() {
        }

        public DBCollectorTaskInfoBuilder version(String version) {
            this.version = version;
            return this;
        }

        public DBCollectorTaskInfoBuilder returnCode(int returnCode) {
            this.returnCode = returnCode;
            return this;
        }

        public DBCollectorTaskInfoBuilder md5(String md5) {
            this.md5 = md5;
            return this;
        }

        public DBCollectorTaskInfoBuilder data(TaskInfo data) {
            this.data = data;
            return this;
        }

        public DBCollectorTaskInfo build() {
            return new DBCollectorTaskInfo(this.version, this.returnCode, this.md5, this.data);
        }

        public String toString() {
            return "DBCollectorTaskInfo.DBCollectorTaskInfoBuilder(version=" + this.version + ", returnCode=" + this.returnCode + ", md5=" + this.md5 + ", data=" + this.data + ")";
        }
    }

    public static class TaskInfo {
        @ApiModelProperty(value="task id")
        private int id;
        @ApiModelProperty(value="task type")
        private int type;
        @ApiModelProperty(value="db type")
        private int dbType;
        @ApiModelProperty(value="ip")
        private String ip;
        @ApiModelProperty(value="db port")
        private int dbPort;
        @ApiModelProperty(value="db name")
        private String dbName;
        @ApiModelProperty(value="user")
        private String user;
        @ApiModelProperty(value="password")
        private String password;
        @ApiModelProperty(value="sql")
        private String sqlStatement;
        @ApiModelProperty(value="total limit of data lines")
        private int totalLimit;
        @ApiModelProperty(value="the limit of one batch")
        private int onceLimit;
        @ApiModelProperty(value="task will be forced out after time limit")
        private int timeLimit;
        @ApiModelProperty(value="retry times if task failes")
        private int retryTimes;
        @ApiModelProperty(value="inlong groupid")
        private String inlongGroupId;
        @ApiModelProperty(value="inlong streamId")
        private String inlongStreamId;

        public int getId() {
            return this.id;
        }

        public int getType() {
            return this.type;
        }

        public int getDBType() {
            return this.dbType;
        }

        public String getIp() {
            return this.ip;
        }

        public int getDBPort() {
            return this.dbPort;
        }

        public String getDBName() {
            return this.dbName;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getSqlStatement() {
            return this.sqlStatement;
        }

        public int getTotalLimit() {
            return this.totalLimit;
        }

        public int getOnceLimit() {
            return this.onceLimit;
        }

        public int getTimeLimit() {
            return this.timeLimit;
        }

        public int getRetryTimes() {
            return this.retryTimes;
        }

        public String getInlongGroupId() {
            return this.inlongGroupId;
        }

        public String getInlongStreamId() {
            return this.inlongStreamId;
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setType(int type) {
            this.type = type;
        }

        public void setDBType(int dbType) {
            this.dbType = dbType;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public void setDBPort(int dbPort) {
            this.dbPort = dbPort;
        }

        public void setDBName(String dbName) {
            this.dbName = dbName;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setSqlStatement(String sql) {
            this.sqlStatement = sql;
        }

        public void setTotalLimit(int totalLimit) {
            this.totalLimit = totalLimit;
        }

        public void setOnceLimit(int onceLimit) {
            this.onceLimit = onceLimit;
        }

        public void setTimeLimit(int timeLimit) {
            this.timeLimit = timeLimit;
        }

        public void setRetryTimes(int retryTimes) {
            this.retryTimes = retryTimes;
        }

        public void setInlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
        }

        public void setInlongStreamId(String inlongStreamId) {
            this.inlongStreamId = inlongStreamId;
        }
    }
}

