/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.group;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.apache.inlong.manager.common.beans.PageRequest;

@ApiModel(value="Inlong group query request")
public class InlongGroupPageRequest
extends PageRequest {
    @ApiModelProperty(value="Keyword, can be group id or name")
    private String keyword;
    @ApiModelProperty(value="Inlong group id list")
    private List<String> groupIdList;
    @ApiModelProperty(value="MQ type")
    private String mqType;
    @ApiModelProperty(value="Group status")
    private Integer status;
    @ApiModelProperty(value="Group status list")
    private List<Integer> statusList;
    @ApiModelProperty(value="The inlong cluster tag list")
    private List<String> clusterTagList;
    @ApiModelProperty(value="Current user", hidden=true)
    private String currentUser;
    @ApiModelProperty(value="Whether the current user is in the administrator role", hidden=true)
    private Boolean isAdminRole;
    @ApiModelProperty(value="If list streamSource for group", hidden=true)
    private boolean listSources = false;

    public static InlongGroupPageRequestBuilder builder() {
        return new InlongGroupPageRequestBuilder();
    }

    public String getKeyword() {
        return this.keyword;
    }

    public List<String> getGroupIdList() {
        return this.groupIdList;
    }

    public String getMqType() {
        return this.mqType;
    }

    public Integer getStatus() {
        return this.status;
    }

    public List<Integer> getStatusList() {
        return this.statusList;
    }

    public List<String> getClusterTagList() {
        return this.clusterTagList;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public Boolean getIsAdminRole() {
        return this.isAdminRole;
    }

    public boolean isListSources() {
        return this.listSources;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setGroupIdList(List<String> groupIdList) {
        this.groupIdList = groupIdList;
    }

    public void setMqType(String mqType) {
        this.mqType = mqType;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setStatusList(List<Integer> statusList) {
        this.statusList = statusList;
    }

    public void setClusterTagList(List<String> clusterTagList) {
        this.clusterTagList = clusterTagList;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    public void setIsAdminRole(Boolean isAdminRole) {
        this.isAdminRole = isAdminRole;
    }

    public void setListSources(boolean listSources) {
        this.listSources = listSources;
    }

    public String toString() {
        return "InlongGroupPageRequest(keyword=" + this.getKeyword() + ", groupIdList=" + this.getGroupIdList() + ", mqType=" + this.getMqType() + ", status=" + this.getStatus() + ", statusList=" + this.getStatusList() + ", clusterTagList=" + this.getClusterTagList() + ", currentUser=" + this.getCurrentUser() + ", isAdminRole=" + this.getIsAdminRole() + ", listSources=" + this.isListSources() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongGroupPageRequest)) {
            return false;
        }
        InlongGroupPageRequest other = (InlongGroupPageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isListSources() != other.isListSources()) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Boolean this$isAdminRole = this.getIsAdminRole();
        Boolean other$isAdminRole = other.getIsAdminRole();
        if (this$isAdminRole == null ? other$isAdminRole != null : !((Object)this$isAdminRole).equals(other$isAdminRole)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        if (this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword)) {
            return false;
        }
        List<String> this$groupIdList = this.getGroupIdList();
        List<String> other$groupIdList = other.getGroupIdList();
        if (this$groupIdList == null ? other$groupIdList != null : !((Object)this$groupIdList).equals(other$groupIdList)) {
            return false;
        }
        String this$mqType = this.getMqType();
        String other$mqType = other.getMqType();
        if (this$mqType == null ? other$mqType != null : !this$mqType.equals(other$mqType)) {
            return false;
        }
        List<Integer> this$statusList = this.getStatusList();
        List<Integer> other$statusList = other.getStatusList();
        if (this$statusList == null ? other$statusList != null : !((Object)this$statusList).equals(other$statusList)) {
            return false;
        }
        List<String> this$clusterTagList = this.getClusterTagList();
        List<String> other$clusterTagList = other.getClusterTagList();
        if (this$clusterTagList == null ? other$clusterTagList != null : !((Object)this$clusterTagList).equals(other$clusterTagList)) {
            return false;
        }
        String this$currentUser = this.getCurrentUser();
        String other$currentUser = other.getCurrentUser();
        return !(this$currentUser == null ? other$currentUser != null : !this$currentUser.equals(other$currentUser));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlongGroupPageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isListSources() ? 79 : 97);
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Boolean $isAdminRole = this.getIsAdminRole();
        result = result * 59 + ($isAdminRole == null ? 43 : ((Object)$isAdminRole).hashCode());
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        List<String> $groupIdList = this.getGroupIdList();
        result = result * 59 + ($groupIdList == null ? 43 : ((Object)$groupIdList).hashCode());
        String $mqType = this.getMqType();
        result = result * 59 + ($mqType == null ? 43 : $mqType.hashCode());
        List<Integer> $statusList = this.getStatusList();
        result = result * 59 + ($statusList == null ? 43 : ((Object)$statusList).hashCode());
        List<String> $clusterTagList = this.getClusterTagList();
        result = result * 59 + ($clusterTagList == null ? 43 : ((Object)$clusterTagList).hashCode());
        String $currentUser = this.getCurrentUser();
        result = result * 59 + ($currentUser == null ? 43 : $currentUser.hashCode());
        return result;
    }

    public InlongGroupPageRequest() {
    }

    public InlongGroupPageRequest(String keyword, List<String> groupIdList, String mqType, Integer status, List<Integer> statusList, List<String> clusterTagList, String currentUser, Boolean isAdminRole, boolean listSources) {
        this.keyword = keyword;
        this.groupIdList = groupIdList;
        this.mqType = mqType;
        this.status = status;
        this.statusList = statusList;
        this.clusterTagList = clusterTagList;
        this.currentUser = currentUser;
        this.isAdminRole = isAdminRole;
        this.listSources = listSources;
    }

    public static class InlongGroupPageRequestBuilder {
        private String keyword;
        private List<String> groupIdList;
        private String mqType;
        private Integer status;
        private List<Integer> statusList;
        private List<String> clusterTagList;
        private String currentUser;
        private Boolean isAdminRole;
        private boolean listSources;

        InlongGroupPageRequestBuilder() {
        }

        public InlongGroupPageRequestBuilder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public InlongGroupPageRequestBuilder groupIdList(List<String> groupIdList) {
            this.groupIdList = groupIdList;
            return this;
        }

        public InlongGroupPageRequestBuilder mqType(String mqType) {
            this.mqType = mqType;
            return this;
        }

        public InlongGroupPageRequestBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        public InlongGroupPageRequestBuilder statusList(List<Integer> statusList) {
            this.statusList = statusList;
            return this;
        }

        public InlongGroupPageRequestBuilder clusterTagList(List<String> clusterTagList) {
            this.clusterTagList = clusterTagList;
            return this;
        }

        public InlongGroupPageRequestBuilder currentUser(String currentUser) {
            this.currentUser = currentUser;
            return this;
        }

        public InlongGroupPageRequestBuilder isAdminRole(Boolean isAdminRole) {
            this.isAdminRole = isAdminRole;
            return this;
        }

        public InlongGroupPageRequestBuilder listSources(boolean listSources) {
            this.listSources = listSources;
            return this;
        }

        public InlongGroupPageRequest build() {
            return new InlongGroupPageRequest(this.keyword, this.groupIdList, this.mqType, this.status, this.statusList, this.clusterTagList, this.currentUser, this.isAdminRole, this.listSources);
        }

        public String toString() {
            return "InlongGroupPageRequest.InlongGroupPageRequestBuilder(keyword=" + this.keyword + ", groupIdList=" + this.groupIdList + ", mqType=" + this.mqType + ", status=" + this.status + ", statusList=" + this.statusList + ", clusterTagList=" + this.clusterTagList + ", currentUser=" + this.currentUser + ", isAdminRole=" + this.isAdminRole + ", listSources=" + this.listSources + ")";
        }
    }
}

