/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.group;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupExtInfo;
import org.apache.inlong.manager.common.util.SmallTools;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="Inlong group create request")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="mqType")
public class InlongGroupRequest {
    @ApiModelProperty(value="Inlong group id", required=true)
    @Length(min=4, max=200)
    @Pattern(regexp="^(?![0-9]+$)[a-z][a-z0-9_-]{1,200}$", message="inlongGroupId must starts with a lowercase letter and contains only lowercase letters, digits, `-` or `_`")
    private @Length(min=4, max=200) @Pattern(regexp="^(?![0-9]+$)[a-z][a-z0-9_-]{1,200}$", message="inlongGroupId must starts with a lowercase letter and contains only lowercase letters, digits, `-` or `_`") String inlongGroupId;
    @ApiModelProperty(value="Inlong group name", required=true)
    private String name;
    @ApiModelProperty(value="Inlong group description")
    private String description;
    @NotBlank
    @ApiModelProperty(value="MQ type, high throughput: TUBE, high consistency: PULSAR")
    private String mqType;
    @ApiModelProperty(value="MQ resource", notes="in inlong group, Tube corresponds to Topic, Pulsar corresponds to Namespace")
    private String mqResource;
    @ApiModelProperty(value="Tube master URL")
    private String tubeMaster;
    @ApiModelProperty(value="Whether to enable zookeeper? 0: disable, 1: enable")
    private Integer enableZookeeper;
    @ApiModelProperty(value="Whether to enable zookeeper? 0: disable, 1: enable")
    private Integer enableCreateResource;
    @ApiModelProperty(value="Whether to use lightweight mode, 0: false, 1: true")
    private Integer lightweight;
    @ApiModelProperty(value="Inlong cluster tag, which links to inlong_cluster table")
    private String inlongClusterTag;
    @ApiModelProperty(value="Number of access items per day, unit: 10,000 items per day")
    private Integer dailyRecords;
    @ApiModelProperty(value="Access size per day, unit: GB per day")
    private Integer dailyStorage;
    @ApiModelProperty(value="peak access per second, unit: bars per second")
    private Integer peakRecords;
    @ApiModelProperty(value="The maximum length of a single piece of data, unit: Byte")
    private Integer maxLength;
    @ApiModelProperty(value="Name of responsible person, separated by commas")
    @NotBlank
    private String inCharges;
    @ApiModelProperty(value="Name of followers, separated by commas")
    private String followers;
    @ApiModelProperty(value="Name of creator")
    private String creator;
    @ApiModelProperty(value="Inlong group Extension properties")
    private List<InlongGroupExtInfo> extList;

    public void checkParams() {
        if (StringUtils.isBlank((CharSequence)this.inlongGroupId)) {
            throw new BusinessException("inlongGroupId cannot be null");
        }
        if (this.inlongGroupId.length() < 4 || this.inlongGroupId.length() > 200) {
            throw new BusinessException("characters for inlongGroupId must be more than 4 and less than 200");
        }
        if (!SmallTools.isLowerOrNum(this.inlongGroupId)) {
            throw new BusinessException("inlongGroupId must starts with a lowercase letter and contains only lowercase letters, digits, `-` or `_`");
        }
        if (StringUtils.isBlank((CharSequence)this.mqType)) {
            throw new BusinessException("mqType cannot be null");
        }
        if (StringUtils.isBlank((CharSequence)this.inCharges)) {
            throw new BusinessException("inCharges cannot be null");
        }
    }

    private static Integer $default$enableZookeeper() {
        return 0;
    }

    private static Integer $default$enableCreateResource() {
        return 1;
    }

    private static Integer $default$lightweight() {
        return 0;
    }

    public static InlongGroupRequestBuilder builder() {
        return new InlongGroupRequestBuilder();
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMqType() {
        return this.mqType;
    }

    public String getMqResource() {
        return this.mqResource;
    }

    public String getTubeMaster() {
        return this.tubeMaster;
    }

    public Integer getEnableZookeeper() {
        return this.enableZookeeper;
    }

    public Integer getEnableCreateResource() {
        return this.enableCreateResource;
    }

    public Integer getLightweight() {
        return this.lightweight;
    }

    public String getInlongClusterTag() {
        return this.inlongClusterTag;
    }

    public Integer getDailyRecords() {
        return this.dailyRecords;
    }

    public Integer getDailyStorage() {
        return this.dailyStorage;
    }

    public Integer getPeakRecords() {
        return this.peakRecords;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public String getFollowers() {
        return this.followers;
    }

    public String getCreator() {
        return this.creator;
    }

    public List<InlongGroupExtInfo> getExtList() {
        return this.extList;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMqType(String mqType) {
        this.mqType = mqType;
    }

    public void setMqResource(String mqResource) {
        this.mqResource = mqResource;
    }

    public void setTubeMaster(String tubeMaster) {
        this.tubeMaster = tubeMaster;
    }

    public void setEnableZookeeper(Integer enableZookeeper) {
        this.enableZookeeper = enableZookeeper;
    }

    public void setEnableCreateResource(Integer enableCreateResource) {
        this.enableCreateResource = enableCreateResource;
    }

    public void setLightweight(Integer lightweight) {
        this.lightweight = lightweight;
    }

    public void setInlongClusterTag(String inlongClusterTag) {
        this.inlongClusterTag = inlongClusterTag;
    }

    public void setDailyRecords(Integer dailyRecords) {
        this.dailyRecords = dailyRecords;
    }

    public void setDailyStorage(Integer dailyStorage) {
        this.dailyStorage = dailyStorage;
    }

    public void setPeakRecords(Integer peakRecords) {
        this.peakRecords = peakRecords;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setFollowers(String followers) {
        this.followers = followers;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setExtList(List<InlongGroupExtInfo> extList) {
        this.extList = extList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongGroupRequest)) {
            return false;
        }
        InlongGroupRequest other = (InlongGroupRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$enableZookeeper = this.getEnableZookeeper();
        Integer other$enableZookeeper = other.getEnableZookeeper();
        if (this$enableZookeeper == null ? other$enableZookeeper != null : !((Object)this$enableZookeeper).equals(other$enableZookeeper)) {
            return false;
        }
        Integer this$enableCreateResource = this.getEnableCreateResource();
        Integer other$enableCreateResource = other.getEnableCreateResource();
        if (this$enableCreateResource == null ? other$enableCreateResource != null : !((Object)this$enableCreateResource).equals(other$enableCreateResource)) {
            return false;
        }
        Integer this$lightweight = this.getLightweight();
        Integer other$lightweight = other.getLightweight();
        if (this$lightweight == null ? other$lightweight != null : !((Object)this$lightweight).equals(other$lightweight)) {
            return false;
        }
        Integer this$dailyRecords = this.getDailyRecords();
        Integer other$dailyRecords = other.getDailyRecords();
        if (this$dailyRecords == null ? other$dailyRecords != null : !((Object)this$dailyRecords).equals(other$dailyRecords)) {
            return false;
        }
        Integer this$dailyStorage = this.getDailyStorage();
        Integer other$dailyStorage = other.getDailyStorage();
        if (this$dailyStorage == null ? other$dailyStorage != null : !((Object)this$dailyStorage).equals(other$dailyStorage)) {
            return false;
        }
        Integer this$peakRecords = this.getPeakRecords();
        Integer other$peakRecords = other.getPeakRecords();
        if (this$peakRecords == null ? other$peakRecords != null : !((Object)this$peakRecords).equals(other$peakRecords)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$mqType = this.getMqType();
        String other$mqType = other.getMqType();
        if (this$mqType == null ? other$mqType != null : !this$mqType.equals(other$mqType)) {
            return false;
        }
        String this$mqResource = this.getMqResource();
        String other$mqResource = other.getMqResource();
        if (this$mqResource == null ? other$mqResource != null : !this$mqResource.equals(other$mqResource)) {
            return false;
        }
        String this$tubeMaster = this.getTubeMaster();
        String other$tubeMaster = other.getTubeMaster();
        if (this$tubeMaster == null ? other$tubeMaster != null : !this$tubeMaster.equals(other$tubeMaster)) {
            return false;
        }
        String this$inlongClusterTag = this.getInlongClusterTag();
        String other$inlongClusterTag = other.getInlongClusterTag();
        if (this$inlongClusterTag == null ? other$inlongClusterTag != null : !this$inlongClusterTag.equals(other$inlongClusterTag)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        if (this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges)) {
            return false;
        }
        String this$followers = this.getFollowers();
        String other$followers = other.getFollowers();
        if (this$followers == null ? other$followers != null : !this$followers.equals(other$followers)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        List<InlongGroupExtInfo> this$extList = this.getExtList();
        List<InlongGroupExtInfo> other$extList = other.getExtList();
        return !(this$extList == null ? other$extList != null : !((Object)this$extList).equals(other$extList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlongGroupRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $enableZookeeper = this.getEnableZookeeper();
        result = result * 59 + ($enableZookeeper == null ? 43 : ((Object)$enableZookeeper).hashCode());
        Integer $enableCreateResource = this.getEnableCreateResource();
        result = result * 59 + ($enableCreateResource == null ? 43 : ((Object)$enableCreateResource).hashCode());
        Integer $lightweight = this.getLightweight();
        result = result * 59 + ($lightweight == null ? 43 : ((Object)$lightweight).hashCode());
        Integer $dailyRecords = this.getDailyRecords();
        result = result * 59 + ($dailyRecords == null ? 43 : ((Object)$dailyRecords).hashCode());
        Integer $dailyStorage = this.getDailyStorage();
        result = result * 59 + ($dailyStorage == null ? 43 : ((Object)$dailyStorage).hashCode());
        Integer $peakRecords = this.getPeakRecords();
        result = result * 59 + ($peakRecords == null ? 43 : ((Object)$peakRecords).hashCode());
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $mqType = this.getMqType();
        result = result * 59 + ($mqType == null ? 43 : $mqType.hashCode());
        String $mqResource = this.getMqResource();
        result = result * 59 + ($mqResource == null ? 43 : $mqResource.hashCode());
        String $tubeMaster = this.getTubeMaster();
        result = result * 59 + ($tubeMaster == null ? 43 : $tubeMaster.hashCode());
        String $inlongClusterTag = this.getInlongClusterTag();
        result = result * 59 + ($inlongClusterTag == null ? 43 : $inlongClusterTag.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        String $followers = this.getFollowers();
        result = result * 59 + ($followers == null ? 43 : $followers.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        List<InlongGroupExtInfo> $extList = this.getExtList();
        result = result * 59 + ($extList == null ? 43 : ((Object)$extList).hashCode());
        return result;
    }

    public String toString() {
        return "InlongGroupRequest(inlongGroupId=" + this.getInlongGroupId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", mqType=" + this.getMqType() + ", mqResource=" + this.getMqResource() + ", tubeMaster=" + this.getTubeMaster() + ", enableZookeeper=" + this.getEnableZookeeper() + ", enableCreateResource=" + this.getEnableCreateResource() + ", lightweight=" + this.getLightweight() + ", inlongClusterTag=" + this.getInlongClusterTag() + ", dailyRecords=" + this.getDailyRecords() + ", dailyStorage=" + this.getDailyStorage() + ", peakRecords=" + this.getPeakRecords() + ", maxLength=" + this.getMaxLength() + ", inCharges=" + this.getInCharges() + ", followers=" + this.getFollowers() + ", creator=" + this.getCreator() + ", extList=" + this.getExtList() + ")";
    }

    public InlongGroupRequest() {
        this.enableZookeeper = InlongGroupRequest.$default$enableZookeeper();
        this.enableCreateResource = InlongGroupRequest.$default$enableCreateResource();
        this.lightweight = InlongGroupRequest.$default$lightweight();
    }

    public InlongGroupRequest(String inlongGroupId, String name, String description, String mqType, String mqResource, String tubeMaster, Integer enableZookeeper, Integer enableCreateResource, Integer lightweight, String inlongClusterTag, Integer dailyRecords, Integer dailyStorage, Integer peakRecords, Integer maxLength, String inCharges, String followers, String creator, List<InlongGroupExtInfo> extList) {
        this.inlongGroupId = inlongGroupId;
        this.name = name;
        this.description = description;
        this.mqType = mqType;
        this.mqResource = mqResource;
        this.tubeMaster = tubeMaster;
        this.enableZookeeper = enableZookeeper;
        this.enableCreateResource = enableCreateResource;
        this.lightweight = lightweight;
        this.inlongClusterTag = inlongClusterTag;
        this.dailyRecords = dailyRecords;
        this.dailyStorage = dailyStorage;
        this.peakRecords = peakRecords;
        this.maxLength = maxLength;
        this.inCharges = inCharges;
        this.followers = followers;
        this.creator = creator;
        this.extList = extList;
    }

    public static class InlongGroupRequestBuilder {
        private String inlongGroupId;
        private String name;
        private String description;
        private String mqType;
        private String mqResource;
        private String tubeMaster;
        private boolean enableZookeeper$set;
        private Integer enableZookeeper$value;
        private boolean enableCreateResource$set;
        private Integer enableCreateResource$value;
        private boolean lightweight$set;
        private Integer lightweight$value;
        private String inlongClusterTag;
        private Integer dailyRecords;
        private Integer dailyStorage;
        private Integer peakRecords;
        private Integer maxLength;
        private String inCharges;
        private String followers;
        private String creator;
        private List<InlongGroupExtInfo> extList;

        InlongGroupRequestBuilder() {
        }

        public InlongGroupRequestBuilder inlongGroupId(String inlongGroupId) {
            this.inlongGroupId = inlongGroupId;
            return this;
        }

        public InlongGroupRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public InlongGroupRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        public InlongGroupRequestBuilder mqType(String mqType) {
            this.mqType = mqType;
            return this;
        }

        public InlongGroupRequestBuilder mqResource(String mqResource) {
            this.mqResource = mqResource;
            return this;
        }

        public InlongGroupRequestBuilder tubeMaster(String tubeMaster) {
            this.tubeMaster = tubeMaster;
            return this;
        }

        public InlongGroupRequestBuilder enableZookeeper(Integer enableZookeeper) {
            this.enableZookeeper$value = enableZookeeper;
            this.enableZookeeper$set = true;
            return this;
        }

        public InlongGroupRequestBuilder enableCreateResource(Integer enableCreateResource) {
            this.enableCreateResource$value = enableCreateResource;
            this.enableCreateResource$set = true;
            return this;
        }

        public InlongGroupRequestBuilder lightweight(Integer lightweight) {
            this.lightweight$value = lightweight;
            this.lightweight$set = true;
            return this;
        }

        public InlongGroupRequestBuilder inlongClusterTag(String inlongClusterTag) {
            this.inlongClusterTag = inlongClusterTag;
            return this;
        }

        public InlongGroupRequestBuilder dailyRecords(Integer dailyRecords) {
            this.dailyRecords = dailyRecords;
            return this;
        }

        public InlongGroupRequestBuilder dailyStorage(Integer dailyStorage) {
            this.dailyStorage = dailyStorage;
            return this;
        }

        public InlongGroupRequestBuilder peakRecords(Integer peakRecords) {
            this.peakRecords = peakRecords;
            return this;
        }

        public InlongGroupRequestBuilder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public InlongGroupRequestBuilder inCharges(String inCharges) {
            this.inCharges = inCharges;
            return this;
        }

        public InlongGroupRequestBuilder followers(String followers) {
            this.followers = followers;
            return this;
        }

        public InlongGroupRequestBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public InlongGroupRequestBuilder extList(List<InlongGroupExtInfo> extList) {
            this.extList = extList;
            return this;
        }

        public InlongGroupRequest build() {
            Integer enableZookeeper$value = this.enableZookeeper$value;
            if (!this.enableZookeeper$set) {
                enableZookeeper$value = InlongGroupRequest.$default$enableZookeeper();
            }
            Integer enableCreateResource$value = this.enableCreateResource$value;
            if (!this.enableCreateResource$set) {
                enableCreateResource$value = InlongGroupRequest.$default$enableCreateResource();
            }
            Integer lightweight$value = this.lightweight$value;
            if (!this.lightweight$set) {
                lightweight$value = InlongGroupRequest.$default$lightweight();
            }
            return new InlongGroupRequest(this.inlongGroupId, this.name, this.description, this.mqType, this.mqResource, this.tubeMaster, enableZookeeper$value, enableCreateResource$value, lightweight$value, this.inlongClusterTag, this.dailyRecords, this.dailyStorage, this.peakRecords, this.maxLength, this.inCharges, this.followers, this.creator, this.extList);
        }

        public String toString() {
            return "InlongGroupRequest.InlongGroupRequestBuilder(inlongGroupId=" + this.inlongGroupId + ", name=" + this.name + ", description=" + this.description + ", mqType=" + this.mqType + ", mqResource=" + this.mqResource + ", tubeMaster=" + this.tubeMaster + ", enableZookeeper$value=" + this.enableZookeeper$value + ", enableCreateResource$value=" + this.enableCreateResource$value + ", lightweight$value=" + this.lightweight$value + ", inlongClusterTag=" + this.inlongClusterTag + ", dailyRecords=" + this.dailyRecords + ", dailyStorage=" + this.dailyStorage + ", peakRecords=" + this.peakRecords + ", maxLength=" + this.maxLength + ", inCharges=" + this.inCharges + ", followers=" + this.followers + ", creator=" + this.creator + ", extList=" + this.extList + ")";
        }
    }
}

