/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.sink.es;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.sink.es.ElasticsearchFieldInfo;
import org.apache.inlong.manager.common.pojo.sink.es.ElasticsearchSinkRequest;

public class ElasticsearchSinkDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Elasticsearch Host")
    private String host;
    @ApiModelProperty(value="Elasticsearch Port")
    private Integer port;
    @ApiModelProperty(value="Username for JDBC URL")
    private String username;
    @ApiModelProperty(value="User password")
    private String password;
    @ApiModelProperty(value="Elasticsearch index name")
    private String indexName;
    @ApiModelProperty(value="Flush interval, unit: second, default is 1s")
    private Integer flushInterval;
    @ApiModelProperty(value="Flush when record number reaches flushRecord")
    private Integer flushRecord;
    @ApiModelProperty(value="Write max retry times, default is 3")
    private Integer retryTimes;
    @ApiModelProperty(value="Document Type")
    private String documentType;
    @ApiModelProperty(value="Primary Key")
    private String primaryKey;
    @ApiModelProperty(value="version")
    private Integer version;
    @ApiModelProperty(value="Properties for elasticsearch")
    private Map<String, Object> properties;

    public static ElasticsearchSinkDTO getFromRequest(ElasticsearchSinkRequest request) {
        return ElasticsearchSinkDTO.builder().host(request.getHost()).username(request.getUsername()).password(request.getPassword()).indexName(request.getIndexName()).flushInterval(request.getFlushInterval()).flushRecord(request.getFlushRecord()).retryTimes(request.getRetryTimes()).properties(request.getProperties()).build();
    }

    public static ElasticsearchSinkDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (ElasticsearchSinkDTO)OBJECT_MAPPER.readValue(extParams, ElasticsearchSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT.getMessage());
        }
    }

    public static String getElasticSearchIndexName(ElasticsearchSinkDTO esInfo, List<ElasticsearchFieldInfo> fieldList) {
        return esInfo.getIndexName();
    }

    public static ElasticsearchSinkDTOBuilder builder() {
        return new ElasticsearchSinkDTOBuilder();
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Integer getFlushInterval() {
        return this.flushInterval;
    }

    public Integer getFlushRecord() {
        return this.flushRecord;
    }

    public Integer getRetryTimes() {
        return this.retryTimes;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setFlushInterval(Integer flushInterval) {
        this.flushInterval = flushInterval;
    }

    public void setFlushRecord(Integer flushRecord) {
        this.flushRecord = flushRecord;
    }

    public void setRetryTimes(Integer retryTimes) {
        this.retryTimes = retryTimes;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticsearchSinkDTO)) {
            return false;
        }
        ElasticsearchSinkDTO other = (ElasticsearchSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Integer this$flushInterval = this.getFlushInterval();
        Integer other$flushInterval = other.getFlushInterval();
        if (this$flushInterval == null ? other$flushInterval != null : !((Object)this$flushInterval).equals(other$flushInterval)) {
            return false;
        }
        Integer this$flushRecord = this.getFlushRecord();
        Integer other$flushRecord = other.getFlushRecord();
        if (this$flushRecord == null ? other$flushRecord != null : !((Object)this$flushRecord).equals(other$flushRecord)) {
            return false;
        }
        Integer this$retryTimes = this.getRetryTimes();
        Integer other$retryTimes = other.getRetryTimes();
        if (this$retryTimes == null ? other$retryTimes != null : !((Object)this$retryTimes).equals(other$retryTimes)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        String this$documentType = this.getDocumentType();
        String other$documentType = other.getDocumentType();
        if (this$documentType == null ? other$documentType != null : !this$documentType.equals(other$documentType)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticsearchSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Integer $flushInterval = this.getFlushInterval();
        result = result * 59 + ($flushInterval == null ? 43 : ((Object)$flushInterval).hashCode());
        Integer $flushRecord = this.getFlushRecord();
        result = result * 59 + ($flushRecord == null ? 43 : ((Object)$flushRecord).hashCode());
        Integer $retryTimes = this.getRetryTimes();
        result = result * 59 + ($retryTimes == null ? 43 : ((Object)$retryTimes).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        String $documentType = this.getDocumentType();
        result = result * 59 + ($documentType == null ? 43 : $documentType.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "ElasticsearchSinkDTO(host=" + this.getHost() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", indexName=" + this.getIndexName() + ", flushInterval=" + this.getFlushInterval() + ", flushRecord=" + this.getFlushRecord() + ", retryTimes=" + this.getRetryTimes() + ", documentType=" + this.getDocumentType() + ", primaryKey=" + this.getPrimaryKey() + ", version=" + this.getVersion() + ", properties=" + this.getProperties() + ")";
    }

    public ElasticsearchSinkDTO() {
    }

    public ElasticsearchSinkDTO(String host, Integer port, String username, String password, String indexName, Integer flushInterval, Integer flushRecord, Integer retryTimes, String documentType, String primaryKey, Integer version, Map<String, Object> properties) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.indexName = indexName;
        this.flushInterval = flushInterval;
        this.flushRecord = flushRecord;
        this.retryTimes = retryTimes;
        this.documentType = documentType;
        this.primaryKey = primaryKey;
        this.version = version;
        this.properties = properties;
    }

    public static class ElasticsearchSinkDTOBuilder {
        private String host;
        private Integer port;
        private String username;
        private String password;
        private String indexName;
        private Integer flushInterval;
        private Integer flushRecord;
        private Integer retryTimes;
        private String documentType;
        private String primaryKey;
        private Integer version;
        private Map<String, Object> properties;

        ElasticsearchSinkDTOBuilder() {
        }

        public ElasticsearchSinkDTOBuilder host(String host) {
            this.host = host;
            return this;
        }

        public ElasticsearchSinkDTOBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public ElasticsearchSinkDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public ElasticsearchSinkDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ElasticsearchSinkDTOBuilder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public ElasticsearchSinkDTOBuilder flushInterval(Integer flushInterval) {
            this.flushInterval = flushInterval;
            return this;
        }

        public ElasticsearchSinkDTOBuilder flushRecord(Integer flushRecord) {
            this.flushRecord = flushRecord;
            return this;
        }

        public ElasticsearchSinkDTOBuilder retryTimes(Integer retryTimes) {
            this.retryTimes = retryTimes;
            return this;
        }

        public ElasticsearchSinkDTOBuilder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        public ElasticsearchSinkDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public ElasticsearchSinkDTOBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public ElasticsearchSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public ElasticsearchSinkDTO build() {
            return new ElasticsearchSinkDTO(this.host, this.port, this.username, this.password, this.indexName, this.flushInterval, this.flushRecord, this.retryTimes, this.documentType, this.primaryKey, this.version, this.properties);
        }

        public String toString() {
            return "ElasticsearchSinkDTO.ElasticsearchSinkDTOBuilder(host=" + this.host + ", port=" + this.port + ", username=" + this.username + ", password=" + this.password + ", indexName=" + this.indexName + ", flushInterval=" + this.flushInterval + ", flushRecord=" + this.flushRecord + ", retryTimes=" + this.retryTimes + ", documentType=" + this.documentType + ", primaryKey=" + this.primaryKey + ", version=" + this.version + ", properties=" + this.properties + ")";
        }
    }
}

