/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.sink.hdfs;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.sink.hdfs.HdfsPartitionField;
import org.apache.inlong.manager.common.pojo.sink.hdfs.HdfsSinkRequest;

public class HdfsSinkDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="File format, support: TextFile, RCFile, SequenceFile, Avro")
    private String fileFormat;
    @ApiModelProperty(value="Data path, such as: hdfs://ip:port/usr/hive/warehouse/test.db")
    private String dataPath;
    @ApiModelProperty(value="Compress formt")
    private String compressFormt;
    @ApiModelProperty(value="Server timeZone")
    private String serverTimeZone;
    @ApiModelProperty(value="Data field separator")
    private String dataSeparator;
    @ApiModelProperty(value="Partition field list")
    private List<HdfsPartitionField> partitionFieldList;
    @ApiModelProperty(value="Properties for hbase")
    private Map<String, Object> properties;

    public static HdfsSinkDTO getFromRequest(HdfsSinkRequest request) {
        return HdfsSinkDTO.builder().dataPath(request.getDataPath()).dataSeparator(request.getDataSeparator()).fileFormat(request.getFileFormat()).compressFormt(request.getCompressFormt()).serverTimeZone(request.getServerTimeZone()).partitionFieldList(request.getPartitionFieldList()).properties(request.getProperties()).build();
    }

    public static HdfsSinkDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (HdfsSinkDTO)OBJECT_MAPPER.readValue(extParams, HdfsSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT.getMessage());
        }
    }

    public static HdfsSinkDTOBuilder builder() {
        return new HdfsSinkDTOBuilder();
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getCompressFormt() {
        return this.compressFormt;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public List<HdfsPartitionField> getPartitionFieldList() {
        return this.partitionFieldList;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setCompressFormt(String compressFormt) {
        this.compressFormt = compressFormt;
    }

    public void setServerTimeZone(String serverTimeZone) {
        this.serverTimeZone = serverTimeZone;
    }

    public void setDataSeparator(String dataSeparator) {
        this.dataSeparator = dataSeparator;
    }

    public void setPartitionFieldList(List<HdfsPartitionField> partitionFieldList) {
        this.partitionFieldList = partitionFieldList;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HdfsSinkDTO)) {
            return false;
        }
        HdfsSinkDTO other = (HdfsSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fileFormat = this.getFileFormat();
        String other$fileFormat = other.getFileFormat();
        if (this$fileFormat == null ? other$fileFormat != null : !this$fileFormat.equals(other$fileFormat)) {
            return false;
        }
        String this$dataPath = this.getDataPath();
        String other$dataPath = other.getDataPath();
        if (this$dataPath == null ? other$dataPath != null : !this$dataPath.equals(other$dataPath)) {
            return false;
        }
        String this$compressFormt = this.getCompressFormt();
        String other$compressFormt = other.getCompressFormt();
        if (this$compressFormt == null ? other$compressFormt != null : !this$compressFormt.equals(other$compressFormt)) {
            return false;
        }
        String this$serverTimeZone = this.getServerTimeZone();
        String other$serverTimeZone = other.getServerTimeZone();
        if (this$serverTimeZone == null ? other$serverTimeZone != null : !this$serverTimeZone.equals(other$serverTimeZone)) {
            return false;
        }
        String this$dataSeparator = this.getDataSeparator();
        String other$dataSeparator = other.getDataSeparator();
        if (this$dataSeparator == null ? other$dataSeparator != null : !this$dataSeparator.equals(other$dataSeparator)) {
            return false;
        }
        List<HdfsPartitionField> this$partitionFieldList = this.getPartitionFieldList();
        List<HdfsPartitionField> other$partitionFieldList = other.getPartitionFieldList();
        if (this$partitionFieldList == null ? other$partitionFieldList != null : !((Object)this$partitionFieldList).equals(other$partitionFieldList)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HdfsSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fileFormat = this.getFileFormat();
        result = result * 59 + ($fileFormat == null ? 43 : $fileFormat.hashCode());
        String $dataPath = this.getDataPath();
        result = result * 59 + ($dataPath == null ? 43 : $dataPath.hashCode());
        String $compressFormt = this.getCompressFormt();
        result = result * 59 + ($compressFormt == null ? 43 : $compressFormt.hashCode());
        String $serverTimeZone = this.getServerTimeZone();
        result = result * 59 + ($serverTimeZone == null ? 43 : $serverTimeZone.hashCode());
        String $dataSeparator = this.getDataSeparator();
        result = result * 59 + ($dataSeparator == null ? 43 : $dataSeparator.hashCode());
        List<HdfsPartitionField> $partitionFieldList = this.getPartitionFieldList();
        result = result * 59 + ($partitionFieldList == null ? 43 : ((Object)$partitionFieldList).hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "HdfsSinkDTO(fileFormat=" + this.getFileFormat() + ", dataPath=" + this.getDataPath() + ", compressFormt=" + this.getCompressFormt() + ", serverTimeZone=" + this.getServerTimeZone() + ", dataSeparator=" + this.getDataSeparator() + ", partitionFieldList=" + this.getPartitionFieldList() + ", properties=" + this.getProperties() + ")";
    }

    public HdfsSinkDTO() {
    }

    public HdfsSinkDTO(String fileFormat, String dataPath, String compressFormt, String serverTimeZone, String dataSeparator, List<HdfsPartitionField> partitionFieldList, Map<String, Object> properties) {
        this.fileFormat = fileFormat;
        this.dataPath = dataPath;
        this.compressFormt = compressFormt;
        this.serverTimeZone = serverTimeZone;
        this.dataSeparator = dataSeparator;
        this.partitionFieldList = partitionFieldList;
        this.properties = properties;
    }

    public static class HdfsSinkDTOBuilder {
        private String fileFormat;
        private String dataPath;
        private String compressFormt;
        private String serverTimeZone;
        private String dataSeparator;
        private List<HdfsPartitionField> partitionFieldList;
        private Map<String, Object> properties;

        HdfsSinkDTOBuilder() {
        }

        public HdfsSinkDTOBuilder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        public HdfsSinkDTOBuilder dataPath(String dataPath) {
            this.dataPath = dataPath;
            return this;
        }

        public HdfsSinkDTOBuilder compressFormt(String compressFormt) {
            this.compressFormt = compressFormt;
            return this;
        }

        public HdfsSinkDTOBuilder serverTimeZone(String serverTimeZone) {
            this.serverTimeZone = serverTimeZone;
            return this;
        }

        public HdfsSinkDTOBuilder dataSeparator(String dataSeparator) {
            this.dataSeparator = dataSeparator;
            return this;
        }

        public HdfsSinkDTOBuilder partitionFieldList(List<HdfsPartitionField> partitionFieldList) {
            this.partitionFieldList = partitionFieldList;
            return this;
        }

        public HdfsSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public HdfsSinkDTO build() {
            return new HdfsSinkDTO(this.fileFormat, this.dataPath, this.compressFormt, this.serverTimeZone, this.dataSeparator, this.partitionFieldList, this.properties);
        }

        public String toString() {
            return "HdfsSinkDTO.HdfsSinkDTOBuilder(fileFormat=" + this.fileFormat + ", dataPath=" + this.dataPath + ", compressFormt=" + this.compressFormt + ", serverTimeZone=" + this.serverTimeZone + ", dataSeparator=" + this.dataSeparator + ", partitionFieldList=" + this.partitionFieldList + ", properties=" + this.properties + ")";
        }
    }
}

