/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.sink.iceberg;

import org.apache.inlong.manager.common.util.Preconditions;

public enum IcebergPartition {
    IDENTITY,
    BUCKET,
    TRUNCATE,
    YEAR,
    MONTH,
    DAY,
    HOUR,
    NONE;


    public static IcebergPartition forName(String name) {
        Preconditions.checkNotNull((Object)name, "IcebergPartition should not be null");
        for (IcebergPartition value : IcebergPartition.values()) {
            if (!value.toString().equalsIgnoreCase(name)) continue;
            return value;
        }
        throw new IllegalArgumentException(String.format("Unsupported IcebergPartition : %s", name));
    }

    public String toString() {
        return this.name();
    }
}

