/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.sink.iceberg;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.pojo.sink.SinkRequest;
import org.apache.inlong.manager.common.pojo.sink.StreamSink;
import org.apache.inlong.manager.common.pojo.sink.iceberg.IcebergSinkRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;

@ApiModel(value="Iceberg sink info")
@JsonTypeDefine(value="ICEBERG")
public class IcebergSink
extends StreamSink {
    @ApiModelProperty(value="Catalog URI")
    private String catalogUri;
    @ApiModelProperty(value="Data warehouse")
    private String warehouse;
    @ApiModelProperty(value="Target database name")
    private String dbName;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Data path, such as: hdfs://ip:port/user/hive/warehouse/test.db")
    private String dataPath;
    @ApiModelProperty(value="File format, support: Parquet, Orc, Avro")
    private String fileFormat;
    @ApiModelProperty(value="Catalog type, like: HIVE, HADOOP, default is HIVE")
    private String catalogType = "HIVE";
    @ApiModelProperty(value="Primary key")
    private String primaryKey;

    public IcebergSink() {
        this.setSinkType("ICEBERG");
    }

    @Override
    public SinkRequest genSinkRequest() {
        return CommonBeanUtils.copyProperties(this, IcebergSinkRequest::new);
    }

    protected IcebergSink(IcebergSinkBuilder<?, ?> b) {
        super((StreamSink.StreamSinkBuilder<?, ?>)b);
        this.catalogUri = ((IcebergSinkBuilder)b).catalogUri;
        this.warehouse = ((IcebergSinkBuilder)b).warehouse;
        this.dbName = ((IcebergSinkBuilder)b).dbName;
        this.tableName = ((IcebergSinkBuilder)b).tableName;
        this.dataPath = ((IcebergSinkBuilder)b).dataPath;
        this.fileFormat = ((IcebergSinkBuilder)b).fileFormat;
        this.catalogType = ((IcebergSinkBuilder)b).catalogType;
        this.primaryKey = ((IcebergSinkBuilder)b).primaryKey;
    }

    public static IcebergSinkBuilder<?, ?> builder() {
        return new IcebergSinkBuilderImpl();
    }

    public String getCatalogUri() {
        return this.catalogUri;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public String getCatalogType() {
        return this.catalogType;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setCatalogUri(String catalogUri) {
        this.catalogUri = catalogUri;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void setCatalogType(String catalogType) {
        this.catalogType = catalogType;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public IcebergSink(String catalogUri, String warehouse, String dbName, String tableName, String dataPath, String fileFormat, String catalogType, String primaryKey) {
        this.catalogUri = catalogUri;
        this.warehouse = warehouse;
        this.dbName = dbName;
        this.tableName = tableName;
        this.dataPath = dataPath;
        this.fileFormat = fileFormat;
        this.catalogType = catalogType;
        this.primaryKey = primaryKey;
    }

    @Override
    public String toString() {
        return "IcebergSink(super=" + super.toString() + ", catalogUri=" + this.getCatalogUri() + ", warehouse=" + this.getWarehouse() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", dataPath=" + this.getDataPath() + ", fileFormat=" + this.getFileFormat() + ", catalogType=" + this.getCatalogType() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IcebergSink)) {
            return false;
        }
        IcebergSink other = (IcebergSink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$catalogUri = this.getCatalogUri();
        String other$catalogUri = other.getCatalogUri();
        if (this$catalogUri == null ? other$catalogUri != null : !this$catalogUri.equals(other$catalogUri)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$dataPath = this.getDataPath();
        String other$dataPath = other.getDataPath();
        if (this$dataPath == null ? other$dataPath != null : !this$dataPath.equals(other$dataPath)) {
            return false;
        }
        String this$fileFormat = this.getFileFormat();
        String other$fileFormat = other.getFileFormat();
        if (this$fileFormat == null ? other$fileFormat != null : !this$fileFormat.equals(other$fileFormat)) {
            return false;
        }
        String this$catalogType = this.getCatalogType();
        String other$catalogType = other.getCatalogType();
        if (this$catalogType == null ? other$catalogType != null : !this$catalogType.equals(other$catalogType)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IcebergSink;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $catalogUri = this.getCatalogUri();
        result = result * 59 + ($catalogUri == null ? 43 : $catalogUri.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $dataPath = this.getDataPath();
        result = result * 59 + ($dataPath == null ? 43 : $dataPath.hashCode());
        String $fileFormat = this.getFileFormat();
        result = result * 59 + ($fileFormat == null ? 43 : $fileFormat.hashCode());
        String $catalogType = this.getCatalogType();
        result = result * 59 + ($catalogType == null ? 43 : $catalogType.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    private static final class IcebergSinkBuilderImpl
    extends IcebergSinkBuilder<IcebergSink, IcebergSinkBuilderImpl> {
        private IcebergSinkBuilderImpl() {
        }

        @Override
        protected IcebergSinkBuilderImpl self() {
            return this;
        }

        @Override
        public IcebergSink build() {
            return new IcebergSink(this);
        }
    }

    public static abstract class IcebergSinkBuilder<C extends IcebergSink, B extends IcebergSinkBuilder<C, B>>
    extends StreamSink.StreamSinkBuilder<C, B> {
        private String catalogUri;
        private String warehouse;
        private String dbName;
        private String tableName;
        private String dataPath;
        private String fileFormat;
        private String catalogType;
        private String primaryKey;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B catalogUri(String catalogUri) {
            this.catalogUri = catalogUri;
            return (B)this.self();
        }

        public B warehouse(String warehouse) {
            this.warehouse = warehouse;
            return (B)this.self();
        }

        public B dbName(String dbName) {
            this.dbName = dbName;
            return (B)this.self();
        }

        public B tableName(String tableName) {
            this.tableName = tableName;
            return (B)this.self();
        }

        public B dataPath(String dataPath) {
            this.dataPath = dataPath;
            return (B)this.self();
        }

        public B fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return (B)this.self();
        }

        public B catalogType(String catalogType) {
            this.catalogType = catalogType;
            return (B)this.self();
        }

        public B primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "IcebergSink.IcebergSinkBuilder(super=" + super.toString() + ", catalogUri=" + this.catalogUri + ", warehouse=" + this.warehouse + ", dbName=" + this.dbName + ", tableName=" + this.tableName + ", dataPath=" + this.dataPath + ", fileFormat=" + this.fileFormat + ", catalogType=" + this.catalogType + ", primaryKey=" + this.primaryKey + ")";
        }
    }
}

