/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.sink.iceberg;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.sink.iceberg.IcebergColumnInfo;
import org.apache.inlong.manager.common.pojo.sink.iceberg.IcebergSinkRequest;
import org.apache.inlong.manager.common.pojo.sink.iceberg.IcebergTableInfo;

public class IcebergSinkDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Catalog uri, such as hive metastore thrift://ip:port")
    private String catalogUri;
    @ApiModelProperty(value="Iceberg data warehouse dir")
    private String warehouse;
    @ApiModelProperty(value="Target database name")
    private String dbName;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Data path, such as: hdfs://ip:port/user/hive/warehouse/test.db")
    private String dataPath;
    @ApiModelProperty(value="File format, support: Parquet, Orc, Avro")
    private String fileFormat;
    @ApiModelProperty(value="Catalog type, like: hive, hadoop, default is hive")
    private String catalogType;
    @ApiModelProperty(value="Primary key")
    private String primaryKey;
    @ApiModelProperty(value="Properties for iceberg")
    private Map<String, Object> properties;

    public static IcebergSinkDTO getFromRequest(IcebergSinkRequest request) {
        return IcebergSinkDTO.builder().catalogUri(request.getCatalogUri()).warehouse(request.getWarehouse()).dbName(request.getDbName()).tableName(request.getTableName()).dataPath(request.getDataPath()).fileFormat(request.getFileFormat()).catalogType(request.getCatalogType()).primaryKey(request.getPrimaryKey()).properties(request.getProperties()).build();
    }

    public static IcebergSinkDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (IcebergSinkDTO)OBJECT_MAPPER.readValue(extParams, IcebergSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT.getMessage());
        }
    }

    public static IcebergTableInfo getIcebergTableInfo(IcebergSinkDTO icebergInfo, List<IcebergColumnInfo> columnList) {
        IcebergTableInfo info = new IcebergTableInfo();
        info.setDbName(icebergInfo.getDbName());
        info.setTableName(icebergInfo.getTableName());
        info.setFileFormat(icebergInfo.getFileFormat());
        info.setTblProperties(icebergInfo.getProperties());
        info.setColumns(columnList);
        return info;
    }

    public static IcebergSinkDTOBuilder builder() {
        return new IcebergSinkDTOBuilder();
    }

    public String getCatalogUri() {
        return this.catalogUri;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public String getCatalogType() {
        return this.catalogType;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setCatalogUri(String catalogUri) {
        this.catalogUri = catalogUri;
    }

    public void setWarehouse(String warehouse) {
        this.warehouse = warehouse;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public void setCatalogType(String catalogType) {
        this.catalogType = catalogType;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IcebergSinkDTO)) {
            return false;
        }
        IcebergSinkDTO other = (IcebergSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$catalogUri = this.getCatalogUri();
        String other$catalogUri = other.getCatalogUri();
        if (this$catalogUri == null ? other$catalogUri != null : !this$catalogUri.equals(other$catalogUri)) {
            return false;
        }
        String this$warehouse = this.getWarehouse();
        String other$warehouse = other.getWarehouse();
        if (this$warehouse == null ? other$warehouse != null : !this$warehouse.equals(other$warehouse)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$dataPath = this.getDataPath();
        String other$dataPath = other.getDataPath();
        if (this$dataPath == null ? other$dataPath != null : !this$dataPath.equals(other$dataPath)) {
            return false;
        }
        String this$fileFormat = this.getFileFormat();
        String other$fileFormat = other.getFileFormat();
        if (this$fileFormat == null ? other$fileFormat != null : !this$fileFormat.equals(other$fileFormat)) {
            return false;
        }
        String this$catalogType = this.getCatalogType();
        String other$catalogType = other.getCatalogType();
        if (this$catalogType == null ? other$catalogType != null : !this$catalogType.equals(other$catalogType)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IcebergSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $catalogUri = this.getCatalogUri();
        result = result * 59 + ($catalogUri == null ? 43 : $catalogUri.hashCode());
        String $warehouse = this.getWarehouse();
        result = result * 59 + ($warehouse == null ? 43 : $warehouse.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $dataPath = this.getDataPath();
        result = result * 59 + ($dataPath == null ? 43 : $dataPath.hashCode());
        String $fileFormat = this.getFileFormat();
        result = result * 59 + ($fileFormat == null ? 43 : $fileFormat.hashCode());
        String $catalogType = this.getCatalogType();
        result = result * 59 + ($catalogType == null ? 43 : $catalogType.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "IcebergSinkDTO(catalogUri=" + this.getCatalogUri() + ", warehouse=" + this.getWarehouse() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", dataPath=" + this.getDataPath() + ", fileFormat=" + this.getFileFormat() + ", catalogType=" + this.getCatalogType() + ", primaryKey=" + this.getPrimaryKey() + ", properties=" + this.getProperties() + ")";
    }

    public IcebergSinkDTO() {
    }

    public IcebergSinkDTO(String catalogUri, String warehouse, String dbName, String tableName, String dataPath, String fileFormat, String catalogType, String primaryKey, Map<String, Object> properties) {
        this.catalogUri = catalogUri;
        this.warehouse = warehouse;
        this.dbName = dbName;
        this.tableName = tableName;
        this.dataPath = dataPath;
        this.fileFormat = fileFormat;
        this.catalogType = catalogType;
        this.primaryKey = primaryKey;
        this.properties = properties;
    }

    public static class IcebergSinkDTOBuilder {
        private String catalogUri;
        private String warehouse;
        private String dbName;
        private String tableName;
        private String dataPath;
        private String fileFormat;
        private String catalogType;
        private String primaryKey;
        private Map<String, Object> properties;

        IcebergSinkDTOBuilder() {
        }

        public IcebergSinkDTOBuilder catalogUri(String catalogUri) {
            this.catalogUri = catalogUri;
            return this;
        }

        public IcebergSinkDTOBuilder warehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        public IcebergSinkDTOBuilder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public IcebergSinkDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public IcebergSinkDTOBuilder dataPath(String dataPath) {
            this.dataPath = dataPath;
            return this;
        }

        public IcebergSinkDTOBuilder fileFormat(String fileFormat) {
            this.fileFormat = fileFormat;
            return this;
        }

        public IcebergSinkDTOBuilder catalogType(String catalogType) {
            this.catalogType = catalogType;
            return this;
        }

        public IcebergSinkDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public IcebergSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public IcebergSinkDTO build() {
            return new IcebergSinkDTO(this.catalogUri, this.warehouse, this.dbName, this.tableName, this.dataPath, this.fileFormat, this.catalogType, this.primaryKey, this.properties);
        }

        public String toString() {
            return "IcebergSinkDTO.IcebergSinkDTOBuilder(catalogUri=" + this.catalogUri + ", warehouse=" + this.warehouse + ", dbName=" + this.dbName + ", tableName=" + this.tableName + ", dataPath=" + this.dataPath + ", fileFormat=" + this.fileFormat + ", catalogType=" + this.catalogType + ", primaryKey=" + this.primaryKey + ", properties=" + this.properties + ")";
        }
    }
}

