/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.sink.postgres;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.sink.postgres.PostgresColumnInfo;
import org.apache.inlong.manager.common.pojo.sink.postgres.PostgresSinkRequest;
import org.apache.inlong.manager.common.pojo.sink.postgres.PostgresTableInfo;

public class PostgresSinkDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="postgres JDBC URL")
    private String jdbcUrl;
    @ApiModelProperty(value="Username for JDBC URL")
    private String username;
    @ApiModelProperty(value="User password")
    private String password;
    @ApiModelProperty(value="Target database name")
    private String dbName;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Primary key")
    private String primaryKey;
    @ApiModelProperty(value="Properties for postgres")
    private Map<String, Object> properties;

    public static PostgresSinkDTO getFromRequest(PostgresSinkRequest request) {
        return PostgresSinkDTO.builder().jdbcUrl(request.getJdbcUrl()).username(request.getUsername()).password(request.getPassword()).dbName(request.getDbName()).primaryKey(request.getPrimaryKey()).tableName(request.getTableName()).properties(request.getProperties()).build();
    }

    public static PostgresSinkDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (PostgresSinkDTO)OBJECT_MAPPER.readValue(extParams, PostgresSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT.getMessage());
        }
    }

    public static PostgresTableInfo getPostgresTableInfo(PostgresSinkDTO pgSink, List<PostgresColumnInfo> columnList) {
        PostgresTableInfo tableInfo = new PostgresTableInfo();
        tableInfo.setDbName(pgSink.getDbName());
        tableInfo.setTableName(pgSink.getTableName());
        tableInfo.setPrimaryKey(pgSink.getPrimaryKey());
        tableInfo.setColumns(columnList);
        return tableInfo;
    }

    public static PostgresSinkDTOBuilder builder() {
        return new PostgresSinkDTOBuilder();
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostgresSinkDTO)) {
            return false;
        }
        PostgresSinkDTO other = (PostgresSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PostgresSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "PostgresSinkDTO(jdbcUrl=" + this.getJdbcUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", primaryKey=" + this.getPrimaryKey() + ", properties=" + this.getProperties() + ")";
    }

    public PostgresSinkDTO() {
    }

    public PostgresSinkDTO(String jdbcUrl, String username, String password, String dbName, String tableName, String primaryKey, Map<String, Object> properties) {
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
        this.dbName = dbName;
        this.tableName = tableName;
        this.primaryKey = primaryKey;
        this.properties = properties;
    }

    public static class PostgresSinkDTOBuilder {
        private String jdbcUrl;
        private String username;
        private String password;
        private String dbName;
        private String tableName;
        private String primaryKey;
        private Map<String, Object> properties;

        PostgresSinkDTOBuilder() {
        }

        public PostgresSinkDTOBuilder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public PostgresSinkDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public PostgresSinkDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public PostgresSinkDTOBuilder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public PostgresSinkDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public PostgresSinkDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public PostgresSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public PostgresSinkDTO build() {
            return new PostgresSinkDTO(this.jdbcUrl, this.username, this.password, this.dbName, this.tableName, this.primaryKey, this.properties);
        }

        public String toString() {
            return "PostgresSinkDTO.PostgresSinkDTOBuilder(jdbcUrl=" + this.jdbcUrl + ", username=" + this.username + ", password=" + this.password + ", dbName=" + this.dbName + ", tableName=" + this.tableName + ", primaryKey=" + this.primaryKey + ", properties=" + this.properties + ")";
        }
    }
}

