/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.sink.sqlserver;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.sink.sqlserver.SqlServerSinkRequest;

public class SqlServerSinkDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Username of the Sqlserver")
    private String username;
    @ApiModelProperty(value="Password of the Sqlserver")
    private String password;
    @ApiModelProperty(value="sqlserver meta db URL, etc jdbc:sqlserver://host:port;databaseName=database")
    private String jdbcUrl;
    @ApiModelProperty(value="schemaName of the Sqlserver")
    private String schemaName;
    @ApiModelProperty(value="tableName of the Sqlserver")
    private String tableName;
    @ApiModelProperty(value="Database time zone, Default is UTC")
    private String serverTimezone;
    @ApiModelProperty(value="Whether to migrate all databases")
    private boolean allMigration;
    @ApiModelProperty(value="Primary key must be shared by all tables")
    private String primaryKey;

    public static SqlServerSinkDTO getFromRequest(SqlServerSinkRequest request) {
        return SqlServerSinkDTO.builder().username(request.getUsername()).password(request.getPassword()).jdbcUrl(request.getJdbcUrl()).schemaName(request.getSchemaName()).tableName(request.getTableName()).serverTimezone(request.getServerTimezone()).allMigration(request.isAllMigration()).primaryKey(request.getPrimaryKey()).build();
    }

    public static SqlServerSinkDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (SqlServerSinkDTO)OBJECT_MAPPER.readValue(extParams, SqlServerSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage());
        }
    }

    public static SqlServerSinkDTOBuilder builder() {
        return new SqlServerSinkDTOBuilder();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getServerTimezone() {
        return this.serverTimezone;
    }

    public boolean isAllMigration() {
        return this.allMigration;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setServerTimezone(String serverTimezone) {
        this.serverTimezone = serverTimezone;
    }

    public void setAllMigration(boolean allMigration) {
        this.allMigration = allMigration;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlServerSinkDTO)) {
            return false;
        }
        SqlServerSinkDTO other = (SqlServerSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAllMigration() != other.isAllMigration()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$serverTimezone = this.getServerTimezone();
        String other$serverTimezone = other.getServerTimezone();
        if (this$serverTimezone == null ? other$serverTimezone != null : !this$serverTimezone.equals(other$serverTimezone)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqlServerSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllMigration() ? 79 : 97);
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $serverTimezone = this.getServerTimezone();
        result = result * 59 + ($serverTimezone == null ? 43 : $serverTimezone.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    public String toString() {
        return "SqlServerSinkDTO(username=" + this.getUsername() + ", password=" + this.getPassword() + ", jdbcUrl=" + this.getJdbcUrl() + ", schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ", serverTimezone=" + this.getServerTimezone() + ", allMigration=" + this.isAllMigration() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    public SqlServerSinkDTO() {
    }

    public SqlServerSinkDTO(String username, String password, String jdbcUrl, String schemaName, String tableName, String serverTimezone, boolean allMigration, String primaryKey) {
        this.username = username;
        this.password = password;
        this.jdbcUrl = jdbcUrl;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.serverTimezone = serverTimezone;
        this.allMigration = allMigration;
        this.primaryKey = primaryKey;
    }

    public static class SqlServerSinkDTOBuilder {
        private String username;
        private String password;
        private String jdbcUrl;
        private String schemaName;
        private String tableName;
        private String serverTimezone;
        private boolean allMigration;
        private String primaryKey;

        SqlServerSinkDTOBuilder() {
        }

        public SqlServerSinkDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public SqlServerSinkDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public SqlServerSinkDTOBuilder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public SqlServerSinkDTOBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public SqlServerSinkDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public SqlServerSinkDTOBuilder serverTimezone(String serverTimezone) {
            this.serverTimezone = serverTimezone;
            return this;
        }

        public SqlServerSinkDTOBuilder allMigration(boolean allMigration) {
            this.allMigration = allMigration;
            return this;
        }

        public SqlServerSinkDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public SqlServerSinkDTO build() {
            return new SqlServerSinkDTO(this.username, this.password, this.jdbcUrl, this.schemaName, this.tableName, this.serverTimezone, this.allMigration, this.primaryKey);
        }

        public String toString() {
            return "SqlServerSinkDTO.SqlServerSinkDTOBuilder(username=" + this.username + ", password=" + this.password + ", jdbcUrl=" + this.jdbcUrl + ", schemaName=" + this.schemaName + ", tableName=" + this.tableName + ", serverTimezone=" + this.serverTimezone + ", allMigration=" + this.allMigration + ", primaryKey=" + this.primaryKey + ")";
        }
    }
}

