/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.sort;

import io.swagger.annotations.ApiModel;

@ApiModel(value="Sort configuration for inlong group")
public abstract class BaseSortConf {
    public abstract SortType getType();

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseSortConf)) {
            return false;
        }
        BaseSortConf other = (BaseSortConf)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseSortConf;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "BaseSortConf()";
    }

    public static enum SortType {
        FLINK("flink"),
        LOCAL("local"),
        USER_DEFINED("user_defined");

        private final String type;

        private SortType(String type) {
            this.type = type;
        }

        public static SortType forType(String type) {
            for (SortType sortType : SortType.values()) {
                if (!sortType.getType().equals(type)) continue;
                return sortType;
            }
            throw new IllegalArgumentException(String.format("Unsupported sortType=%s", type));
        }

        public String getType() {
            return this.type;
        }
    }
}

