/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.autopush;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.pojo.source.SourceRequest;
import org.apache.inlong.manager.common.pojo.source.StreamSource;
import org.apache.inlong.manager.common.pojo.source.autopush.AutoPushSourceRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;

@ApiModel(value="Auto push source info")
@JsonTypeDefine(value="AUTO_PUSH")
public class AutoPushSource
extends StreamSource {
    @ApiModelProperty(value="DataProxy group name, used when the user enables local configuration")
    private String dataProxyGroup;

    public AutoPushSource() {
        this.setSourceType(SourceType.AUTO_PUSH.name());
    }

    @Override
    public SourceRequest genSourceRequest() {
        return CommonBeanUtils.copyProperties(this, AutoPushSourceRequest::new);
    }

    protected AutoPushSource(AutoPushSourceBuilder<?, ?> b) {
        super((StreamSource.StreamSourceBuilder<?, ?>)b);
        this.dataProxyGroup = ((AutoPushSourceBuilder)b).dataProxyGroup;
    }

    public static AutoPushSourceBuilder<?, ?> builder() {
        return new AutoPushSourceBuilderImpl();
    }

    public String getDataProxyGroup() {
        return this.dataProxyGroup;
    }

    public void setDataProxyGroup(String dataProxyGroup) {
        this.dataProxyGroup = dataProxyGroup;
    }

    public AutoPushSource(String dataProxyGroup) {
        this.dataProxyGroup = dataProxyGroup;
    }

    @Override
    public String toString() {
        return "AutoPushSource(super=" + super.toString() + ", dataProxyGroup=" + this.getDataProxyGroup() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoPushSource)) {
            return false;
        }
        AutoPushSource other = (AutoPushSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$dataProxyGroup = this.getDataProxyGroup();
        String other$dataProxyGroup = other.getDataProxyGroup();
        return !(this$dataProxyGroup == null ? other$dataProxyGroup != null : !this$dataProxyGroup.equals(other$dataProxyGroup));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AutoPushSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $dataProxyGroup = this.getDataProxyGroup();
        result = result * 59 + ($dataProxyGroup == null ? 43 : $dataProxyGroup.hashCode());
        return result;
    }

    private static final class AutoPushSourceBuilderImpl
    extends AutoPushSourceBuilder<AutoPushSource, AutoPushSourceBuilderImpl> {
        private AutoPushSourceBuilderImpl() {
        }

        @Override
        protected AutoPushSourceBuilderImpl self() {
            return this;
        }

        @Override
        public AutoPushSource build() {
            return new AutoPushSource(this);
        }
    }

    public static abstract class AutoPushSourceBuilder<C extends AutoPushSource, B extends AutoPushSourceBuilder<C, B>>
    extends StreamSource.StreamSourceBuilder<C, B> {
        private String dataProxyGroup;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B dataProxyGroup(String dataProxyGroup) {
            this.dataProxyGroup = dataProxyGroup;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AutoPushSource.AutoPushSourceBuilder(super=" + super.toString() + ", dataProxyGroup=" + this.dataProxyGroup + ")";
        }
    }
}

