/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.autopush;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.source.autopush.AutoPushSourceRequest;

public class AutoPushSourceDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="DataProxy group name, used when the user enables local configuration")
    private String dataProxyGroup;

    public static AutoPushSourceDTO getFromRequest(AutoPushSourceRequest request) {
        return AutoPushSourceDTO.builder().dataProxyGroup(request.getDataProxyGroup()).build();
    }

    public static AutoPushSourceDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (AutoPushSourceDTO)OBJECT_MAPPER.readValue(extParams, AutoPushSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage());
        }
    }

    public static AutoPushSourceDTOBuilder builder() {
        return new AutoPushSourceDTOBuilder();
    }

    public String getDataProxyGroup() {
        return this.dataProxyGroup;
    }

    public void setDataProxyGroup(String dataProxyGroup) {
        this.dataProxyGroup = dataProxyGroup;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoPushSourceDTO)) {
            return false;
        }
        AutoPushSourceDTO other = (AutoPushSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dataProxyGroup = this.getDataProxyGroup();
        String other$dataProxyGroup = other.getDataProxyGroup();
        return !(this$dataProxyGroup == null ? other$dataProxyGroup != null : !this$dataProxyGroup.equals(other$dataProxyGroup));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoPushSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dataProxyGroup = this.getDataProxyGroup();
        result = result * 59 + ($dataProxyGroup == null ? 43 : $dataProxyGroup.hashCode());
        return result;
    }

    public String toString() {
        return "AutoPushSourceDTO(dataProxyGroup=" + this.getDataProxyGroup() + ")";
    }

    public AutoPushSourceDTO() {
    }

    public AutoPushSourceDTO(String dataProxyGroup) {
        this.dataProxyGroup = dataProxyGroup;
    }

    public static class AutoPushSourceDTOBuilder {
        private String dataProxyGroup;

        AutoPushSourceDTOBuilder() {
        }

        public AutoPushSourceDTOBuilder dataProxyGroup(String dataProxyGroup) {
            this.dataProxyGroup = dataProxyGroup;
            return this;
        }

        public AutoPushSourceDTO build() {
            return new AutoPushSourceDTO(this.dataProxyGroup);
        }

        public String toString() {
            return "AutoPushSourceDTO.AutoPushSourceDTOBuilder(dataProxyGroup=" + this.dataProxyGroup + ")";
        }
    }
}

