/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.file;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.source.file.FileSourceRequest;

public class FileSourceDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Agent IP address")
    private String ip;
    @ApiModelProperty(value="Path regex pattern for file, such as /a/b/*.txt")
    private String pattern;
    @ApiModelProperty(value="TimeOffset for collection, '1m' means from one minute after, '-1m' means from one minute before, '1h' means from one hour after, '-1h' means from one minute before, '1d' means from one day after, '-1d' means from one minute before, Null or blank means from current timestamp")
    private String timeOffset;

    public static FileSourceDTO getFromRequest(@NotNull FileSourceRequest fileSourceRequest) {
        return FileSourceDTO.builder().ip(fileSourceRequest.getIp()).pattern(fileSourceRequest.getPattern()).timeOffset(fileSourceRequest.getTimeOffset()).build();
    }

    public static FileSourceDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (FileSourceDTO)OBJECT_MAPPER.readValue(extParams, FileSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage());
        }
    }

    public static FileSourceDTOBuilder builder() {
        return new FileSourceDTOBuilder();
    }

    public FileSourceDTO(String ip, String pattern, String timeOffset) {
        this.ip = ip;
        this.pattern = pattern;
        this.timeOffset = timeOffset;
    }

    public FileSourceDTO() {
    }

    public String getIp() {
        return this.ip;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getTimeOffset() {
        return this.timeOffset;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setTimeOffset(String timeOffset) {
        this.timeOffset = timeOffset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSourceDTO)) {
            return false;
        }
        FileSourceDTO other = (FileSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        String this$timeOffset = this.getTimeOffset();
        String other$timeOffset = other.getTimeOffset();
        return !(this$timeOffset == null ? other$timeOffset != null : !this$timeOffset.equals(other$timeOffset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        String $timeOffset = this.getTimeOffset();
        result = result * 59 + ($timeOffset == null ? 43 : $timeOffset.hashCode());
        return result;
    }

    public String toString() {
        return "FileSourceDTO(ip=" + this.getIp() + ", pattern=" + this.getPattern() + ", timeOffset=" + this.getTimeOffset() + ")";
    }

    public static class FileSourceDTOBuilder {
        private String ip;
        private String pattern;
        private String timeOffset;

        FileSourceDTOBuilder() {
        }

        public FileSourceDTOBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public FileSourceDTOBuilder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public FileSourceDTOBuilder timeOffset(String timeOffset) {
            this.timeOffset = timeOffset;
            return this;
        }

        public FileSourceDTO build() {
            return new FileSourceDTO(this.ip, this.pattern, this.timeOffset);
        }

        public String toString() {
            return "FileSourceDTO.FileSourceDTOBuilder(ip=" + this.ip + ", pattern=" + this.pattern + ", timeOffset=" + this.timeOffset + ")";
        }
    }
}

