/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.file;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.pojo.source.SourceListResponse;
import org.apache.inlong.manager.common.util.JsonTypeDefine;

@ApiModel(value="Response of file source paging list")
@JsonTypeDefine(value="FILE")
public class FileSourceListResponse
extends SourceListResponse {
    @ApiModelProperty(value="Agent IP address")
    private String ip;
    @ApiModelProperty(value="Path regex pattern for file, such as /a/b/*.txt")
    private String pattern;
    @ApiModelProperty(value="TimeOffset for collection, '1m' means from one minute after, '-1m' means from one minute before, '1h' means from one hour after, '-1h' means from one minute before, '1d' means from one day after, '-1d' means from one minute before, Null or blank means from current timestamp")
    private String timeOffset;

    public FileSourceListResponse() {
        this.setSourceType(SourceType.FILE.getType());
    }

    protected FileSourceListResponse(FileSourceListResponseBuilder<?, ?> b) {
        super(b);
        this.ip = ((FileSourceListResponseBuilder)b).ip;
        this.pattern = ((FileSourceListResponseBuilder)b).pattern;
        this.timeOffset = ((FileSourceListResponseBuilder)b).timeOffset;
    }

    public static FileSourceListResponseBuilder<?, ?> builder() {
        return new FileSourceListResponseBuilderImpl();
    }

    public String getIp() {
        return this.ip;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getTimeOffset() {
        return this.timeOffset;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setTimeOffset(String timeOffset) {
        this.timeOffset = timeOffset;
    }

    @Override
    public String toString() {
        return "FileSourceListResponse(ip=" + this.getIp() + ", pattern=" + this.getPattern() + ", timeOffset=" + this.getTimeOffset() + ")";
    }

    public FileSourceListResponse(String ip, String pattern, String timeOffset) {
        this.ip = ip;
        this.pattern = pattern;
        this.timeOffset = timeOffset;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSourceListResponse)) {
            return false;
        }
        FileSourceListResponse other = (FileSourceListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        String this$timeOffset = this.getTimeOffset();
        String other$timeOffset = other.getTimeOffset();
        return !(this$timeOffset == null ? other$timeOffset != null : !this$timeOffset.equals(other$timeOffset));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FileSourceListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        String $timeOffset = this.getTimeOffset();
        result = result * 59 + ($timeOffset == null ? 43 : $timeOffset.hashCode());
        return result;
    }

    private static final class FileSourceListResponseBuilderImpl
    extends FileSourceListResponseBuilder<FileSourceListResponse, FileSourceListResponseBuilderImpl> {
        private FileSourceListResponseBuilderImpl() {
        }

        @Override
        protected FileSourceListResponseBuilderImpl self() {
            return this;
        }

        @Override
        public FileSourceListResponse build() {
            return new FileSourceListResponse(this);
        }
    }

    public static abstract class FileSourceListResponseBuilder<C extends FileSourceListResponse, B extends FileSourceListResponseBuilder<C, B>>
    extends SourceListResponse.SourceListResponseBuilder<C, B> {
        private String ip;
        private String pattern;
        private String timeOffset;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B ip(String ip) {
            this.ip = ip;
            return (B)this.self();
        }

        public B pattern(String pattern) {
            this.pattern = pattern;
            return (B)this.self();
        }

        public B timeOffset(String timeOffset) {
            this.timeOffset = timeOffset;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FileSourceListResponse.FileSourceListResponseBuilder(super=" + super.toString() + ", ip=" + this.ip + ", pattern=" + this.pattern + ", timeOffset=" + this.timeOffset + ")";
        }
    }
}

