/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.kafka;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.pojo.source.SourceRequest;
import org.apache.inlong.manager.common.pojo.source.StreamSource;
import org.apache.inlong.manager.common.pojo.source.kafka.KafkaSourceRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;

@ApiModel(value="Kafka source info")
@JsonTypeDefine(value="KAFKA")
public class KafkaSource
extends StreamSource {
    @ApiModelProperty(value="Kafka topic")
    private String topic;
    @ApiModelProperty(value="Kafka consumer group")
    private String groupId;
    @ApiModelProperty(value="Kafka servers address")
    private String bootstrapServers;
    @ApiModelProperty(value="Limit the amount of data read per second")
    private String recordSpeedLimit;
    @ApiModelProperty(value="Limit the number of bytes read per second")
    private String byteSpeedLimit;
    @ApiModelProperty(value="Topic partition offset")
    private String topicPartitionOffset;
    @ApiModelProperty(value="The strategy of auto offset reset")
    private String autoOffsetReset;
    @ApiModelProperty(value="database pattern used for filter in canal format")
    private String databasePattern;
    @ApiModelProperty(value="table pattern used for filter in canal format")
    private String tablePattern;
    @ApiModelProperty(value="ignore parse errors, true: ignore parse error; false: not ignore parse error; default true")
    private boolean ignoreParseErrors;
    @ApiModelProperty(value="Timestamp standard for binlog: SQL, ISO_8601")
    private String timestampFormatStandard;
    @ApiModelProperty(value="Primary key, needed when serialization type is csv, json, avro")
    private String primaryKey;

    public KafkaSource() {
        this.setSourceType(SourceType.KAFKA.name());
    }

    @Override
    public SourceRequest genSourceRequest() {
        return CommonBeanUtils.copyProperties(this, KafkaSourceRequest::new);
    }

    protected KafkaSource(KafkaSourceBuilder<?, ?> b) {
        super((StreamSource.StreamSourceBuilder<?, ?>)b);
        this.topic = ((KafkaSourceBuilder)b).topic;
        this.groupId = ((KafkaSourceBuilder)b).groupId;
        this.bootstrapServers = ((KafkaSourceBuilder)b).bootstrapServers;
        this.recordSpeedLimit = ((KafkaSourceBuilder)b).recordSpeedLimit;
        this.byteSpeedLimit = ((KafkaSourceBuilder)b).byteSpeedLimit;
        this.topicPartitionOffset = ((KafkaSourceBuilder)b).topicPartitionOffset;
        this.autoOffsetReset = ((KafkaSourceBuilder)b).autoOffsetReset;
        this.databasePattern = ((KafkaSourceBuilder)b).databasePattern;
        this.tablePattern = ((KafkaSourceBuilder)b).tablePattern;
        this.ignoreParseErrors = ((KafkaSourceBuilder)b).ignoreParseErrors;
        this.timestampFormatStandard = ((KafkaSourceBuilder)b).timestampFormatStandard;
        this.primaryKey = ((KafkaSourceBuilder)b).primaryKey;
    }

    public static KafkaSourceBuilder<?, ?> builder() {
        return new KafkaSourceBuilderImpl();
    }

    public String getTopic() {
        return this.topic;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getRecordSpeedLimit() {
        return this.recordSpeedLimit;
    }

    public String getByteSpeedLimit() {
        return this.byteSpeedLimit;
    }

    public String getTopicPartitionOffset() {
        return this.topicPartitionOffset;
    }

    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public String getDatabasePattern() {
        return this.databasePattern;
    }

    public String getTablePattern() {
        return this.tablePattern;
    }

    public boolean isIgnoreParseErrors() {
        return this.ignoreParseErrors;
    }

    public String getTimestampFormatStandard() {
        return this.timestampFormatStandard;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public void setRecordSpeedLimit(String recordSpeedLimit) {
        this.recordSpeedLimit = recordSpeedLimit;
    }

    public void setByteSpeedLimit(String byteSpeedLimit) {
        this.byteSpeedLimit = byteSpeedLimit;
    }

    public void setTopicPartitionOffset(String topicPartitionOffset) {
        this.topicPartitionOffset = topicPartitionOffset;
    }

    public void setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
    }

    public void setDatabasePattern(String databasePattern) {
        this.databasePattern = databasePattern;
    }

    public void setTablePattern(String tablePattern) {
        this.tablePattern = tablePattern;
    }

    public void setIgnoreParseErrors(boolean ignoreParseErrors) {
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public void setTimestampFormatStandard(String timestampFormatStandard) {
        this.timestampFormatStandard = timestampFormatStandard;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public KafkaSource(String topic, String groupId, String bootstrapServers, String recordSpeedLimit, String byteSpeedLimit, String topicPartitionOffset, String autoOffsetReset, String databasePattern, String tablePattern, boolean ignoreParseErrors, String timestampFormatStandard, String primaryKey) {
        this.topic = topic;
        this.groupId = groupId;
        this.bootstrapServers = bootstrapServers;
        this.recordSpeedLimit = recordSpeedLimit;
        this.byteSpeedLimit = byteSpeedLimit;
        this.topicPartitionOffset = topicPartitionOffset;
        this.autoOffsetReset = autoOffsetReset;
        this.databasePattern = databasePattern;
        this.tablePattern = tablePattern;
        this.ignoreParseErrors = ignoreParseErrors;
        this.timestampFormatStandard = timestampFormatStandard;
        this.primaryKey = primaryKey;
    }

    @Override
    public String toString() {
        return "KafkaSource(super=" + super.toString() + ", topic=" + this.getTopic() + ", groupId=" + this.getGroupId() + ", bootstrapServers=" + this.getBootstrapServers() + ", recordSpeedLimit=" + this.getRecordSpeedLimit() + ", byteSpeedLimit=" + this.getByteSpeedLimit() + ", topicPartitionOffset=" + this.getTopicPartitionOffset() + ", autoOffsetReset=" + this.getAutoOffsetReset() + ", databasePattern=" + this.getDatabasePattern() + ", tablePattern=" + this.getTablePattern() + ", ignoreParseErrors=" + this.isIgnoreParseErrors() + ", timestampFormatStandard=" + this.getTimestampFormatStandard() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaSource)) {
            return false;
        }
        KafkaSource other = (KafkaSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isIgnoreParseErrors() != other.isIgnoreParseErrors()) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$recordSpeedLimit = this.getRecordSpeedLimit();
        String other$recordSpeedLimit = other.getRecordSpeedLimit();
        if (this$recordSpeedLimit == null ? other$recordSpeedLimit != null : !this$recordSpeedLimit.equals(other$recordSpeedLimit)) {
            return false;
        }
        String this$byteSpeedLimit = this.getByteSpeedLimit();
        String other$byteSpeedLimit = other.getByteSpeedLimit();
        if (this$byteSpeedLimit == null ? other$byteSpeedLimit != null : !this$byteSpeedLimit.equals(other$byteSpeedLimit)) {
            return false;
        }
        String this$topicPartitionOffset = this.getTopicPartitionOffset();
        String other$topicPartitionOffset = other.getTopicPartitionOffset();
        if (this$topicPartitionOffset == null ? other$topicPartitionOffset != null : !this$topicPartitionOffset.equals(other$topicPartitionOffset)) {
            return false;
        }
        String this$autoOffsetReset = this.getAutoOffsetReset();
        String other$autoOffsetReset = other.getAutoOffsetReset();
        if (this$autoOffsetReset == null ? other$autoOffsetReset != null : !this$autoOffsetReset.equals(other$autoOffsetReset)) {
            return false;
        }
        String this$databasePattern = this.getDatabasePattern();
        String other$databasePattern = other.getDatabasePattern();
        if (this$databasePattern == null ? other$databasePattern != null : !this$databasePattern.equals(other$databasePattern)) {
            return false;
        }
        String this$tablePattern = this.getTablePattern();
        String other$tablePattern = other.getTablePattern();
        if (this$tablePattern == null ? other$tablePattern != null : !this$tablePattern.equals(other$tablePattern)) {
            return false;
        }
        String this$timestampFormatStandard = this.getTimestampFormatStandard();
        String other$timestampFormatStandard = other.getTimestampFormatStandard();
        if (this$timestampFormatStandard == null ? other$timestampFormatStandard != null : !this$timestampFormatStandard.equals(other$timestampFormatStandard)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isIgnoreParseErrors() ? 79 : 97);
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $recordSpeedLimit = this.getRecordSpeedLimit();
        result = result * 59 + ($recordSpeedLimit == null ? 43 : $recordSpeedLimit.hashCode());
        String $byteSpeedLimit = this.getByteSpeedLimit();
        result = result * 59 + ($byteSpeedLimit == null ? 43 : $byteSpeedLimit.hashCode());
        String $topicPartitionOffset = this.getTopicPartitionOffset();
        result = result * 59 + ($topicPartitionOffset == null ? 43 : $topicPartitionOffset.hashCode());
        String $autoOffsetReset = this.getAutoOffsetReset();
        result = result * 59 + ($autoOffsetReset == null ? 43 : $autoOffsetReset.hashCode());
        String $databasePattern = this.getDatabasePattern();
        result = result * 59 + ($databasePattern == null ? 43 : $databasePattern.hashCode());
        String $tablePattern = this.getTablePattern();
        result = result * 59 + ($tablePattern == null ? 43 : $tablePattern.hashCode());
        String $timestampFormatStandard = this.getTimestampFormatStandard();
        result = result * 59 + ($timestampFormatStandard == null ? 43 : $timestampFormatStandard.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    private static final class KafkaSourceBuilderImpl
    extends KafkaSourceBuilder<KafkaSource, KafkaSourceBuilderImpl> {
        private KafkaSourceBuilderImpl() {
        }

        @Override
        protected KafkaSourceBuilderImpl self() {
            return this;
        }

        @Override
        public KafkaSource build() {
            return new KafkaSource(this);
        }
    }

    public static abstract class KafkaSourceBuilder<C extends KafkaSource, B extends KafkaSourceBuilder<C, B>>
    extends StreamSource.StreamSourceBuilder<C, B> {
        private String topic;
        private String groupId;
        private String bootstrapServers;
        private String recordSpeedLimit;
        private String byteSpeedLimit;
        private String topicPartitionOffset;
        private String autoOffsetReset;
        private String databasePattern;
        private String tablePattern;
        private boolean ignoreParseErrors;
        private String timestampFormatStandard;
        private String primaryKey;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B topic(String topic) {
            this.topic = topic;
            return (B)this.self();
        }

        public B groupId(String groupId) {
            this.groupId = groupId;
            return (B)this.self();
        }

        public B bootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            return (B)this.self();
        }

        public B recordSpeedLimit(String recordSpeedLimit) {
            this.recordSpeedLimit = recordSpeedLimit;
            return (B)this.self();
        }

        public B byteSpeedLimit(String byteSpeedLimit) {
            this.byteSpeedLimit = byteSpeedLimit;
            return (B)this.self();
        }

        public B topicPartitionOffset(String topicPartitionOffset) {
            this.topicPartitionOffset = topicPartitionOffset;
            return (B)this.self();
        }

        public B autoOffsetReset(String autoOffsetReset) {
            this.autoOffsetReset = autoOffsetReset;
            return (B)this.self();
        }

        public B databasePattern(String databasePattern) {
            this.databasePattern = databasePattern;
            return (B)this.self();
        }

        public B tablePattern(String tablePattern) {
            this.tablePattern = tablePattern;
            return (B)this.self();
        }

        public B ignoreParseErrors(boolean ignoreParseErrors) {
            this.ignoreParseErrors = ignoreParseErrors;
            return (B)this.self();
        }

        public B timestampFormatStandard(String timestampFormatStandard) {
            this.timestampFormatStandard = timestampFormatStandard;
            return (B)this.self();
        }

        public B primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "KafkaSource.KafkaSourceBuilder(super=" + super.toString() + ", topic=" + this.topic + ", groupId=" + this.groupId + ", bootstrapServers=" + this.bootstrapServers + ", recordSpeedLimit=" + this.recordSpeedLimit + ", byteSpeedLimit=" + this.byteSpeedLimit + ", topicPartitionOffset=" + this.topicPartitionOffset + ", autoOffsetReset=" + this.autoOffsetReset + ", databasePattern=" + this.databasePattern + ", tablePattern=" + this.tablePattern + ", ignoreParseErrors=" + this.ignoreParseErrors + ", timestampFormatStandard=" + this.timestampFormatStandard + ", primaryKey=" + this.primaryKey + ")";
        }
    }
}

