/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.kafka;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.source.kafka.KafkaSourceRequest;

public class KafkaSourceDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Kafka topic")
    private String topic;
    @ApiModelProperty(value="Kafka consumer group")
    private String groupId;
    @ApiModelProperty(value="Kafka servers address, such as: 127.0.0.1:9092")
    private String bootstrapServers;
    @ApiModelProperty(value="Limit the amount of data read per second", notes="Greater than or equal to 0, equal to zero means no limit")
    private String recordSpeedLimit;
    @ApiModelProperty(value="Limit the number of bytes read per second", notes="Greater than or equal to 0, equal to zero means no limit")
    private String byteSpeedLimit;
    @ApiModelProperty(value="Topic partition offset", notes="For example, '0#100_1#10' means the offset of partition 0 is 100, the offset of partition 1 is 10")
    private String topicPartitionOffset;
    @ApiModelProperty(value="The strategy of auto offset reset", notes="including earliest, latest (the default), none")
    private String autoOffsetReset;
    @ApiModelProperty(value="Data Serialization, support: json, canal, avro, etc")
    private String serializationType;
    @ApiModelProperty(value="database pattern used for filter in canal format")
    private String databasePattern;
    @ApiModelProperty(value="table pattern used for filter in canal format")
    private String tablePattern;
    @ApiModelProperty(value="ignore parse errors, true: ignore parse error; false: not ignore parse error; default true")
    private boolean ignoreParseErrors;
    @ApiModelProperty(value="Timestamp standard for binlog: SQL, ISO_8601")
    private String timestampFormatStandard;
    @ApiModelProperty(value="Field needed when serializationType is csv,json,avro")
    private String primaryKey;

    public static KafkaSourceDTO getFromRequest(KafkaSourceRequest request) {
        return KafkaSourceDTO.builder().topic(request.getTopic()).groupId(request.getGroupId()).bootstrapServers(request.getBootstrapServers()).recordSpeedLimit(request.getRecordSpeedLimit()).byteSpeedLimit(request.getByteSpeedLimit()).topicPartitionOffset(request.getTopicPartitionOffset()).autoOffsetReset(request.getAutoOffsetReset()).serializationType(request.getSerializationType()).databasePattern(request.getDatabasePattern()).tablePattern(request.getTablePattern()).ignoreParseErrors(request.isIgnoreParseErrors()).timestampFormatStandard(request.getTimestampFormatStandard()).primaryKey(request.getPrimaryKey()).build();
    }

    public static KafkaSourceDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (KafkaSourceDTO)OBJECT_MAPPER.readValue(extParams, KafkaSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage());
        }
    }

    public static KafkaSourceDTOBuilder builder() {
        return new KafkaSourceDTOBuilder();
    }

    public String getTopic() {
        return this.topic;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getRecordSpeedLimit() {
        return this.recordSpeedLimit;
    }

    public String getByteSpeedLimit() {
        return this.byteSpeedLimit;
    }

    public String getTopicPartitionOffset() {
        return this.topicPartitionOffset;
    }

    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public String getSerializationType() {
        return this.serializationType;
    }

    public String getDatabasePattern() {
        return this.databasePattern;
    }

    public String getTablePattern() {
        return this.tablePattern;
    }

    public boolean isIgnoreParseErrors() {
        return this.ignoreParseErrors;
    }

    public String getTimestampFormatStandard() {
        return this.timestampFormatStandard;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public void setRecordSpeedLimit(String recordSpeedLimit) {
        this.recordSpeedLimit = recordSpeedLimit;
    }

    public void setByteSpeedLimit(String byteSpeedLimit) {
        this.byteSpeedLimit = byteSpeedLimit;
    }

    public void setTopicPartitionOffset(String topicPartitionOffset) {
        this.topicPartitionOffset = topicPartitionOffset;
    }

    public void setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
    }

    public void setSerializationType(String serializationType) {
        this.serializationType = serializationType;
    }

    public void setDatabasePattern(String databasePattern) {
        this.databasePattern = databasePattern;
    }

    public void setTablePattern(String tablePattern) {
        this.tablePattern = tablePattern;
    }

    public void setIgnoreParseErrors(boolean ignoreParseErrors) {
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public void setTimestampFormatStandard(String timestampFormatStandard) {
        this.timestampFormatStandard = timestampFormatStandard;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaSourceDTO)) {
            return false;
        }
        KafkaSourceDTO other = (KafkaSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIgnoreParseErrors() != other.isIgnoreParseErrors()) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$recordSpeedLimit = this.getRecordSpeedLimit();
        String other$recordSpeedLimit = other.getRecordSpeedLimit();
        if (this$recordSpeedLimit == null ? other$recordSpeedLimit != null : !this$recordSpeedLimit.equals(other$recordSpeedLimit)) {
            return false;
        }
        String this$byteSpeedLimit = this.getByteSpeedLimit();
        String other$byteSpeedLimit = other.getByteSpeedLimit();
        if (this$byteSpeedLimit == null ? other$byteSpeedLimit != null : !this$byteSpeedLimit.equals(other$byteSpeedLimit)) {
            return false;
        }
        String this$topicPartitionOffset = this.getTopicPartitionOffset();
        String other$topicPartitionOffset = other.getTopicPartitionOffset();
        if (this$topicPartitionOffset == null ? other$topicPartitionOffset != null : !this$topicPartitionOffset.equals(other$topicPartitionOffset)) {
            return false;
        }
        String this$autoOffsetReset = this.getAutoOffsetReset();
        String other$autoOffsetReset = other.getAutoOffsetReset();
        if (this$autoOffsetReset == null ? other$autoOffsetReset != null : !this$autoOffsetReset.equals(other$autoOffsetReset)) {
            return false;
        }
        String this$serializationType = this.getSerializationType();
        String other$serializationType = other.getSerializationType();
        if (this$serializationType == null ? other$serializationType != null : !this$serializationType.equals(other$serializationType)) {
            return false;
        }
        String this$databasePattern = this.getDatabasePattern();
        String other$databasePattern = other.getDatabasePattern();
        if (this$databasePattern == null ? other$databasePattern != null : !this$databasePattern.equals(other$databasePattern)) {
            return false;
        }
        String this$tablePattern = this.getTablePattern();
        String other$tablePattern = other.getTablePattern();
        if (this$tablePattern == null ? other$tablePattern != null : !this$tablePattern.equals(other$tablePattern)) {
            return false;
        }
        String this$timestampFormatStandard = this.getTimestampFormatStandard();
        String other$timestampFormatStandard = other.getTimestampFormatStandard();
        if (this$timestampFormatStandard == null ? other$timestampFormatStandard != null : !this$timestampFormatStandard.equals(other$timestampFormatStandard)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIgnoreParseErrors() ? 79 : 97);
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $recordSpeedLimit = this.getRecordSpeedLimit();
        result = result * 59 + ($recordSpeedLimit == null ? 43 : $recordSpeedLimit.hashCode());
        String $byteSpeedLimit = this.getByteSpeedLimit();
        result = result * 59 + ($byteSpeedLimit == null ? 43 : $byteSpeedLimit.hashCode());
        String $topicPartitionOffset = this.getTopicPartitionOffset();
        result = result * 59 + ($topicPartitionOffset == null ? 43 : $topicPartitionOffset.hashCode());
        String $autoOffsetReset = this.getAutoOffsetReset();
        result = result * 59 + ($autoOffsetReset == null ? 43 : $autoOffsetReset.hashCode());
        String $serializationType = this.getSerializationType();
        result = result * 59 + ($serializationType == null ? 43 : $serializationType.hashCode());
        String $databasePattern = this.getDatabasePattern();
        result = result * 59 + ($databasePattern == null ? 43 : $databasePattern.hashCode());
        String $tablePattern = this.getTablePattern();
        result = result * 59 + ($tablePattern == null ? 43 : $tablePattern.hashCode());
        String $timestampFormatStandard = this.getTimestampFormatStandard();
        result = result * 59 + ($timestampFormatStandard == null ? 43 : $timestampFormatStandard.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    public String toString() {
        return "KafkaSourceDTO(topic=" + this.getTopic() + ", groupId=" + this.getGroupId() + ", bootstrapServers=" + this.getBootstrapServers() + ", recordSpeedLimit=" + this.getRecordSpeedLimit() + ", byteSpeedLimit=" + this.getByteSpeedLimit() + ", topicPartitionOffset=" + this.getTopicPartitionOffset() + ", autoOffsetReset=" + this.getAutoOffsetReset() + ", serializationType=" + this.getSerializationType() + ", databasePattern=" + this.getDatabasePattern() + ", tablePattern=" + this.getTablePattern() + ", ignoreParseErrors=" + this.isIgnoreParseErrors() + ", timestampFormatStandard=" + this.getTimestampFormatStandard() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    public KafkaSourceDTO(String topic, String groupId, String bootstrapServers, String recordSpeedLimit, String byteSpeedLimit, String topicPartitionOffset, String autoOffsetReset, String serializationType, String databasePattern, String tablePattern, boolean ignoreParseErrors, String timestampFormatStandard, String primaryKey) {
        this.topic = topic;
        this.groupId = groupId;
        this.bootstrapServers = bootstrapServers;
        this.recordSpeedLimit = recordSpeedLimit;
        this.byteSpeedLimit = byteSpeedLimit;
        this.topicPartitionOffset = topicPartitionOffset;
        this.autoOffsetReset = autoOffsetReset;
        this.serializationType = serializationType;
        this.databasePattern = databasePattern;
        this.tablePattern = tablePattern;
        this.ignoreParseErrors = ignoreParseErrors;
        this.timestampFormatStandard = timestampFormatStandard;
        this.primaryKey = primaryKey;
    }

    public KafkaSourceDTO() {
    }

    public static class KafkaSourceDTOBuilder {
        private String topic;
        private String groupId;
        private String bootstrapServers;
        private String recordSpeedLimit;
        private String byteSpeedLimit;
        private String topicPartitionOffset;
        private String autoOffsetReset;
        private String serializationType;
        private String databasePattern;
        private String tablePattern;
        private boolean ignoreParseErrors;
        private String timestampFormatStandard;
        private String primaryKey;

        KafkaSourceDTOBuilder() {
        }

        public KafkaSourceDTOBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public KafkaSourceDTOBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public KafkaSourceDTOBuilder bootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            return this;
        }

        public KafkaSourceDTOBuilder recordSpeedLimit(String recordSpeedLimit) {
            this.recordSpeedLimit = recordSpeedLimit;
            return this;
        }

        public KafkaSourceDTOBuilder byteSpeedLimit(String byteSpeedLimit) {
            this.byteSpeedLimit = byteSpeedLimit;
            return this;
        }

        public KafkaSourceDTOBuilder topicPartitionOffset(String topicPartitionOffset) {
            this.topicPartitionOffset = topicPartitionOffset;
            return this;
        }

        public KafkaSourceDTOBuilder autoOffsetReset(String autoOffsetReset) {
            this.autoOffsetReset = autoOffsetReset;
            return this;
        }

        public KafkaSourceDTOBuilder serializationType(String serializationType) {
            this.serializationType = serializationType;
            return this;
        }

        public KafkaSourceDTOBuilder databasePattern(String databasePattern) {
            this.databasePattern = databasePattern;
            return this;
        }

        public KafkaSourceDTOBuilder tablePattern(String tablePattern) {
            this.tablePattern = tablePattern;
            return this;
        }

        public KafkaSourceDTOBuilder ignoreParseErrors(boolean ignoreParseErrors) {
            this.ignoreParseErrors = ignoreParseErrors;
            return this;
        }

        public KafkaSourceDTOBuilder timestampFormatStandard(String timestampFormatStandard) {
            this.timestampFormatStandard = timestampFormatStandard;
            return this;
        }

        public KafkaSourceDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public KafkaSourceDTO build() {
            return new KafkaSourceDTO(this.topic, this.groupId, this.bootstrapServers, this.recordSpeedLimit, this.byteSpeedLimit, this.topicPartitionOffset, this.autoOffsetReset, this.serializationType, this.databasePattern, this.tablePattern, this.ignoreParseErrors, this.timestampFormatStandard, this.primaryKey);
        }

        public String toString() {
            return "KafkaSourceDTO.KafkaSourceDTOBuilder(topic=" + this.topic + ", groupId=" + this.groupId + ", bootstrapServers=" + this.bootstrapServers + ", recordSpeedLimit=" + this.recordSpeedLimit + ", byteSpeedLimit=" + this.byteSpeedLimit + ", topicPartitionOffset=" + this.topicPartitionOffset + ", autoOffsetReset=" + this.autoOffsetReset + ", serializationType=" + this.serializationType + ", databasePattern=" + this.databasePattern + ", tablePattern=" + this.tablePattern + ", ignoreParseErrors=" + this.ignoreParseErrors + ", timestampFormatStandard=" + this.timestampFormatStandard + ", primaryKey=" + this.primaryKey + ")";
        }
    }
}

