/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.kafka;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.pojo.source.SourceListResponse;
import org.apache.inlong.manager.common.util.JsonTypeDefine;

@ApiModel(value="Response of kafka source paging list")
@JsonTypeDefine(value="KAFKA")
public class KafkaSourceListResponse
extends SourceListResponse {
    @ApiModelProperty(value="Kafka topic")
    private String topic;
    @ApiModelProperty(value="Kafka consumer group")
    private String groupId;
    @ApiModelProperty(value="Kafka servers address")
    private String bootstrapServers;
    @ApiModelProperty(value="Limit the amount of data read per second")
    private String recordSpeedLimit;
    @ApiModelProperty(value="Limit the number of bytes read per second")
    private String byteSpeedLimit;
    @ApiModelProperty(value="Topic partition offset", notes="For example, '0#100_1#10' means the offset of partition 0 is 100, the offset of partition 1 is 10")
    private String topicPartitionOffset;
    @ApiModelProperty(value="The strategy of auto offset reset", notes="including earliest, latest (the default), none")
    private String autoOffsetReset;
    @ApiModelProperty(value="Primary key, needed when serialization type is csv, json, avro")
    private String primaryKey;

    public KafkaSourceListResponse() {
        this.setSourceType(SourceType.KAFKA.getType());
    }

    protected KafkaSourceListResponse(KafkaSourceListResponseBuilder<?, ?> b) {
        super(b);
        this.topic = ((KafkaSourceListResponseBuilder)b).topic;
        this.groupId = ((KafkaSourceListResponseBuilder)b).groupId;
        this.bootstrapServers = ((KafkaSourceListResponseBuilder)b).bootstrapServers;
        this.recordSpeedLimit = ((KafkaSourceListResponseBuilder)b).recordSpeedLimit;
        this.byteSpeedLimit = ((KafkaSourceListResponseBuilder)b).byteSpeedLimit;
        this.topicPartitionOffset = ((KafkaSourceListResponseBuilder)b).topicPartitionOffset;
        this.autoOffsetReset = ((KafkaSourceListResponseBuilder)b).autoOffsetReset;
        this.primaryKey = ((KafkaSourceListResponseBuilder)b).primaryKey;
    }

    public static KafkaSourceListResponseBuilder<?, ?> builder() {
        return new KafkaSourceListResponseBuilderImpl();
    }

    public String getTopic() {
        return this.topic;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getRecordSpeedLimit() {
        return this.recordSpeedLimit;
    }

    public String getByteSpeedLimit() {
        return this.byteSpeedLimit;
    }

    public String getTopicPartitionOffset() {
        return this.topicPartitionOffset;
    }

    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public void setRecordSpeedLimit(String recordSpeedLimit) {
        this.recordSpeedLimit = recordSpeedLimit;
    }

    public void setByteSpeedLimit(String byteSpeedLimit) {
        this.byteSpeedLimit = byteSpeedLimit;
    }

    public void setTopicPartitionOffset(String topicPartitionOffset) {
        this.topicPartitionOffset = topicPartitionOffset;
    }

    public void setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Override
    public String toString() {
        return "KafkaSourceListResponse(topic=" + this.getTopic() + ", groupId=" + this.getGroupId() + ", bootstrapServers=" + this.getBootstrapServers() + ", recordSpeedLimit=" + this.getRecordSpeedLimit() + ", byteSpeedLimit=" + this.getByteSpeedLimit() + ", topicPartitionOffset=" + this.getTopicPartitionOffset() + ", autoOffsetReset=" + this.getAutoOffsetReset() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    public KafkaSourceListResponse(String topic, String groupId, String bootstrapServers, String recordSpeedLimit, String byteSpeedLimit, String topicPartitionOffset, String autoOffsetReset, String primaryKey) {
        this.topic = topic;
        this.groupId = groupId;
        this.bootstrapServers = bootstrapServers;
        this.recordSpeedLimit = recordSpeedLimit;
        this.byteSpeedLimit = byteSpeedLimit;
        this.topicPartitionOffset = topicPartitionOffset;
        this.autoOffsetReset = autoOffsetReset;
        this.primaryKey = primaryKey;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaSourceListResponse)) {
            return false;
        }
        KafkaSourceListResponse other = (KafkaSourceListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$recordSpeedLimit = this.getRecordSpeedLimit();
        String other$recordSpeedLimit = other.getRecordSpeedLimit();
        if (this$recordSpeedLimit == null ? other$recordSpeedLimit != null : !this$recordSpeedLimit.equals(other$recordSpeedLimit)) {
            return false;
        }
        String this$byteSpeedLimit = this.getByteSpeedLimit();
        String other$byteSpeedLimit = other.getByteSpeedLimit();
        if (this$byteSpeedLimit == null ? other$byteSpeedLimit != null : !this$byteSpeedLimit.equals(other$byteSpeedLimit)) {
            return false;
        }
        String this$topicPartitionOffset = this.getTopicPartitionOffset();
        String other$topicPartitionOffset = other.getTopicPartitionOffset();
        if (this$topicPartitionOffset == null ? other$topicPartitionOffset != null : !this$topicPartitionOffset.equals(other$topicPartitionOffset)) {
            return false;
        }
        String this$autoOffsetReset = this.getAutoOffsetReset();
        String other$autoOffsetReset = other.getAutoOffsetReset();
        if (this$autoOffsetReset == null ? other$autoOffsetReset != null : !this$autoOffsetReset.equals(other$autoOffsetReset)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaSourceListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $recordSpeedLimit = this.getRecordSpeedLimit();
        result = result * 59 + ($recordSpeedLimit == null ? 43 : $recordSpeedLimit.hashCode());
        String $byteSpeedLimit = this.getByteSpeedLimit();
        result = result * 59 + ($byteSpeedLimit == null ? 43 : $byteSpeedLimit.hashCode());
        String $topicPartitionOffset = this.getTopicPartitionOffset();
        result = result * 59 + ($topicPartitionOffset == null ? 43 : $topicPartitionOffset.hashCode());
        String $autoOffsetReset = this.getAutoOffsetReset();
        result = result * 59 + ($autoOffsetReset == null ? 43 : $autoOffsetReset.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    private static final class KafkaSourceListResponseBuilderImpl
    extends KafkaSourceListResponseBuilder<KafkaSourceListResponse, KafkaSourceListResponseBuilderImpl> {
        private KafkaSourceListResponseBuilderImpl() {
        }

        @Override
        protected KafkaSourceListResponseBuilderImpl self() {
            return this;
        }

        @Override
        public KafkaSourceListResponse build() {
            return new KafkaSourceListResponse(this);
        }
    }

    public static abstract class KafkaSourceListResponseBuilder<C extends KafkaSourceListResponse, B extends KafkaSourceListResponseBuilder<C, B>>
    extends SourceListResponse.SourceListResponseBuilder<C, B> {
        private String topic;
        private String groupId;
        private String bootstrapServers;
        private String recordSpeedLimit;
        private String byteSpeedLimit;
        private String topicPartitionOffset;
        private String autoOffsetReset;
        private String primaryKey;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B topic(String topic) {
            this.topic = topic;
            return (B)this.self();
        }

        public B groupId(String groupId) {
            this.groupId = groupId;
            return (B)this.self();
        }

        public B bootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            return (B)this.self();
        }

        public B recordSpeedLimit(String recordSpeedLimit) {
            this.recordSpeedLimit = recordSpeedLimit;
            return (B)this.self();
        }

        public B byteSpeedLimit(String byteSpeedLimit) {
            this.byteSpeedLimit = byteSpeedLimit;
            return (B)this.self();
        }

        public B topicPartitionOffset(String topicPartitionOffset) {
            this.topicPartitionOffset = topicPartitionOffset;
            return (B)this.self();
        }

        public B autoOffsetReset(String autoOffsetReset) {
            this.autoOffsetReset = autoOffsetReset;
            return (B)this.self();
        }

        public B primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "KafkaSourceListResponse.KafkaSourceListResponseBuilder(super=" + super.toString() + ", topic=" + this.topic + ", groupId=" + this.groupId + ", bootstrapServers=" + this.bootstrapServers + ", recordSpeedLimit=" + this.recordSpeedLimit + ", byteSpeedLimit=" + this.byteSpeedLimit + ", topicPartitionOffset=" + this.topicPartitionOffset + ", autoOffsetReset=" + this.autoOffsetReset + ", primaryKey=" + this.primaryKey + ")";
        }
    }
}

