/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.mongodb;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.pojo.source.SourceRequest;
import org.apache.inlong.manager.common.pojo.source.StreamSource;
import org.apache.inlong.manager.common.pojo.source.mongodb.MongoDBSourceRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;

@ApiModel(value="MongoDB source info")
@JsonTypeDefine(value="MONGODB")
public class MongoDBSource
extends StreamSource {
    @ApiModelProperty(value="MongoDB primaryKey")
    private String primaryKey;
    @ApiModelProperty(value="MongoDB hosts")
    private String hosts;
    @ApiModelProperty(value="MongoDB username")
    private String username;
    @ApiModelProperty(value="MongoDB password")
    private String password;
    @ApiModelProperty(value="MongoDB database")
    private String database;
    @ApiModelProperty(value="MongoDB collection")
    private String collection;

    public MongoDBSource() {
        this.setSourceType(SourceType.MONGODB.name());
    }

    @Override
    public SourceRequest genSourceRequest() {
        return CommonBeanUtils.copyProperties(this, MongoDBSourceRequest::new);
    }

    protected MongoDBSource(MongoDBSourceBuilder<?, ?> b) {
        super((StreamSource.StreamSourceBuilder<?, ?>)b);
        this.primaryKey = ((MongoDBSourceBuilder)b).primaryKey;
        this.hosts = ((MongoDBSourceBuilder)b).hosts;
        this.username = ((MongoDBSourceBuilder)b).username;
        this.password = ((MongoDBSourceBuilder)b).password;
        this.database = ((MongoDBSourceBuilder)b).database;
        this.collection = ((MongoDBSourceBuilder)b).collection;
    }

    public static MongoDBSourceBuilder<?, ?> builder() {
        return new MongoDBSourceBuilderImpl();
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getHosts() {
        return this.hosts;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public MongoDBSource(String primaryKey, String hosts, String username, String password, String database, String collection) {
        this.primaryKey = primaryKey;
        this.hosts = hosts;
        this.username = username;
        this.password = password;
        this.database = database;
        this.collection = collection;
    }

    @Override
    public String toString() {
        return "MongoDBSource(super=" + super.toString() + ", primaryKey=" + this.getPrimaryKey() + ", hosts=" + this.getHosts() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", collection=" + this.getCollection() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MongoDBSource)) {
            return false;
        }
        MongoDBSource other = (MongoDBSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$hosts = this.getHosts();
        String other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !this$hosts.equals(other$hosts)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        return !(this$collection == null ? other$collection != null : !this$collection.equals(other$collection));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MongoDBSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : $hosts.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $collection = this.getCollection();
        result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
        return result;
    }

    private static final class MongoDBSourceBuilderImpl
    extends MongoDBSourceBuilder<MongoDBSource, MongoDBSourceBuilderImpl> {
        private MongoDBSourceBuilderImpl() {
        }

        @Override
        protected MongoDBSourceBuilderImpl self() {
            return this;
        }

        @Override
        public MongoDBSource build() {
            return new MongoDBSource(this);
        }
    }

    public static abstract class MongoDBSourceBuilder<C extends MongoDBSource, B extends MongoDBSourceBuilder<C, B>>
    extends StreamSource.StreamSourceBuilder<C, B> {
        private String primaryKey;
        private String hosts;
        private String username;
        private String password;
        private String database;
        private String collection;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return (B)this.self();
        }

        public B hosts(String hosts) {
            this.hosts = hosts;
            return (B)this.self();
        }

        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        public B database(String database) {
            this.database = database;
            return (B)this.self();
        }

        public B collection(String collection) {
            this.collection = collection;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "MongoDBSource.MongoDBSourceBuilder(super=" + super.toString() + ", primaryKey=" + this.primaryKey + ", hosts=" + this.hosts + ", username=" + this.username + ", password=" + this.password + ", database=" + this.database + ", collection=" + this.collection + ")";
        }
    }
}

