/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.mysql;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.pojo.source.SourceRequest;
import org.apache.inlong.manager.common.pojo.source.StreamSource;
import org.apache.inlong.manager.common.pojo.source.mysql.MySQLBinlogSourceRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;

@ApiModel(value="MySQL binlog source info")
@JsonTypeDefine(value="BINLOG")
public class MySQLBinlogSource
extends StreamSource {
    @ApiModelProperty(value="Username of the DB server")
    private String user;
    @ApiModelProperty(value="Password of the DB server")
    private String password;
    @ApiModelProperty(value="Hostname of the DB server")
    private String hostname;
    @ApiModelProperty(value="Exposed port of the DB server")
    private int port;
    @ApiModelProperty(value="Id of physical node of MySQL Cluster, 0 if single node")
    private Integer serverId = 0;
    @ApiModelProperty(value="Whether include schema, default is 'false'")
    private String includeSchema;
    @ApiModelProperty(value="List of DBs to be collected, seperated by ',', supporting regular expressions")
    private String databaseWhiteList;
    @ApiModelProperty(value="List of tables to be collected, seperated by ',',supporting regular expressions")
    private String tableWhiteList;
    @ApiModelProperty(value="Database time zone, Default is UTC")
    private String serverTimezone;
    @ApiModelProperty(value="The interval for recording an offset")
    private String intervalMs;
    @ApiModelProperty(value="Snapshot mode, supports: initial, when_needed, never, schema_only, schema_only_recovery")
    private String snapshotMode;
    @ApiModelProperty(value="The file path to store offset info")
    private String offsetFilename;
    @ApiModelProperty(value="The file path to store history info")
    private String historyFilename;
    @ApiModelProperty(value="Whether to monitor the DDL, default is 'false'")
    private String monitoredDdl;
    @ApiModelProperty(value="Timestamp standard for binlog: SQL, ISO_8601")
    private String timestampFormatStandard = "SQL";
    @ApiModelProperty(value="Need transfer total database")
    private boolean allMigration;
    @ApiModelProperty(value="Primary key must be shared by all tables", required=false)
    private String primaryKey;

    public MySQLBinlogSource() {
        this.setSourceType(SourceType.BINLOG.name());
    }

    @Override
    public SourceRequest genSourceRequest() {
        return CommonBeanUtils.copyProperties(this, MySQLBinlogSourceRequest::new);
    }

    protected MySQLBinlogSource(MySQLBinlogSourceBuilder<?, ?> b) {
        super((StreamSource.StreamSourceBuilder<?, ?>)b);
        this.user = ((MySQLBinlogSourceBuilder)b).user;
        this.password = ((MySQLBinlogSourceBuilder)b).password;
        this.hostname = ((MySQLBinlogSourceBuilder)b).hostname;
        this.port = ((MySQLBinlogSourceBuilder)b).port;
        this.serverId = ((MySQLBinlogSourceBuilder)b).serverId;
        this.includeSchema = ((MySQLBinlogSourceBuilder)b).includeSchema;
        this.databaseWhiteList = ((MySQLBinlogSourceBuilder)b).databaseWhiteList;
        this.tableWhiteList = ((MySQLBinlogSourceBuilder)b).tableWhiteList;
        this.serverTimezone = ((MySQLBinlogSourceBuilder)b).serverTimezone;
        this.intervalMs = ((MySQLBinlogSourceBuilder)b).intervalMs;
        this.snapshotMode = ((MySQLBinlogSourceBuilder)b).snapshotMode;
        this.offsetFilename = ((MySQLBinlogSourceBuilder)b).offsetFilename;
        this.historyFilename = ((MySQLBinlogSourceBuilder)b).historyFilename;
        this.monitoredDdl = ((MySQLBinlogSourceBuilder)b).monitoredDdl;
        this.timestampFormatStandard = ((MySQLBinlogSourceBuilder)b).timestampFormatStandard;
        this.allMigration = ((MySQLBinlogSourceBuilder)b).allMigration;
        this.primaryKey = ((MySQLBinlogSourceBuilder)b).primaryKey;
    }

    public static MySQLBinlogSourceBuilder<?, ?> builder() {
        return new MySQLBinlogSourceBuilderImpl();
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public Integer getServerId() {
        return this.serverId;
    }

    public String getIncludeSchema() {
        return this.includeSchema;
    }

    public String getDatabaseWhiteList() {
        return this.databaseWhiteList;
    }

    public String getTableWhiteList() {
        return this.tableWhiteList;
    }

    public String getServerTimezone() {
        return this.serverTimezone;
    }

    public String getIntervalMs() {
        return this.intervalMs;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    public String getOffsetFilename() {
        return this.offsetFilename;
    }

    public String getHistoryFilename() {
        return this.historyFilename;
    }

    public String getMonitoredDdl() {
        return this.monitoredDdl;
    }

    public String getTimestampFormatStandard() {
        return this.timestampFormatStandard;
    }

    public boolean isAllMigration() {
        return this.allMigration;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServerId(Integer serverId) {
        this.serverId = serverId;
    }

    public void setIncludeSchema(String includeSchema) {
        this.includeSchema = includeSchema;
    }

    public void setDatabaseWhiteList(String databaseWhiteList) {
        this.databaseWhiteList = databaseWhiteList;
    }

    public void setTableWhiteList(String tableWhiteList) {
        this.tableWhiteList = tableWhiteList;
    }

    public void setServerTimezone(String serverTimezone) {
        this.serverTimezone = serverTimezone;
    }

    public void setIntervalMs(String intervalMs) {
        this.intervalMs = intervalMs;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public void setOffsetFilename(String offsetFilename) {
        this.offsetFilename = offsetFilename;
    }

    public void setHistoryFilename(String historyFilename) {
        this.historyFilename = historyFilename;
    }

    public void setMonitoredDdl(String monitoredDdl) {
        this.monitoredDdl = monitoredDdl;
    }

    public void setTimestampFormatStandard(String timestampFormatStandard) {
        this.timestampFormatStandard = timestampFormatStandard;
    }

    public void setAllMigration(boolean allMigration) {
        this.allMigration = allMigration;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public MySQLBinlogSource(String user, String password, String hostname, int port, Integer serverId, String includeSchema, String databaseWhiteList, String tableWhiteList, String serverTimezone, String intervalMs, String snapshotMode, String offsetFilename, String historyFilename, String monitoredDdl, String timestampFormatStandard, boolean allMigration, String primaryKey) {
        this.user = user;
        this.password = password;
        this.hostname = hostname;
        this.port = port;
        this.serverId = serverId;
        this.includeSchema = includeSchema;
        this.databaseWhiteList = databaseWhiteList;
        this.tableWhiteList = tableWhiteList;
        this.serverTimezone = serverTimezone;
        this.intervalMs = intervalMs;
        this.snapshotMode = snapshotMode;
        this.offsetFilename = offsetFilename;
        this.historyFilename = historyFilename;
        this.monitoredDdl = monitoredDdl;
        this.timestampFormatStandard = timestampFormatStandard;
        this.allMigration = allMigration;
        this.primaryKey = primaryKey;
    }

    @Override
    public String toString() {
        return "MySQLBinlogSource(super=" + super.toString() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", serverId=" + this.getServerId() + ", includeSchema=" + this.getIncludeSchema() + ", databaseWhiteList=" + this.getDatabaseWhiteList() + ", tableWhiteList=" + this.getTableWhiteList() + ", serverTimezone=" + this.getServerTimezone() + ", intervalMs=" + this.getIntervalMs() + ", snapshotMode=" + this.getSnapshotMode() + ", offsetFilename=" + this.getOffsetFilename() + ", historyFilename=" + this.getHistoryFilename() + ", monitoredDdl=" + this.getMonitoredDdl() + ", timestampFormatStandard=" + this.getTimestampFormatStandard() + ", allMigration=" + this.isAllMigration() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MySQLBinlogSource)) {
            return false;
        }
        MySQLBinlogSource other = (MySQLBinlogSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isAllMigration() != other.isAllMigration()) {
            return false;
        }
        Integer this$serverId = this.getServerId();
        Integer other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !((Object)this$serverId).equals(other$serverId)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$includeSchema = this.getIncludeSchema();
        String other$includeSchema = other.getIncludeSchema();
        if (this$includeSchema == null ? other$includeSchema != null : !this$includeSchema.equals(other$includeSchema)) {
            return false;
        }
        String this$databaseWhiteList = this.getDatabaseWhiteList();
        String other$databaseWhiteList = other.getDatabaseWhiteList();
        if (this$databaseWhiteList == null ? other$databaseWhiteList != null : !this$databaseWhiteList.equals(other$databaseWhiteList)) {
            return false;
        }
        String this$tableWhiteList = this.getTableWhiteList();
        String other$tableWhiteList = other.getTableWhiteList();
        if (this$tableWhiteList == null ? other$tableWhiteList != null : !this$tableWhiteList.equals(other$tableWhiteList)) {
            return false;
        }
        String this$serverTimezone = this.getServerTimezone();
        String other$serverTimezone = other.getServerTimezone();
        if (this$serverTimezone == null ? other$serverTimezone != null : !this$serverTimezone.equals(other$serverTimezone)) {
            return false;
        }
        String this$intervalMs = this.getIntervalMs();
        String other$intervalMs = other.getIntervalMs();
        if (this$intervalMs == null ? other$intervalMs != null : !this$intervalMs.equals(other$intervalMs)) {
            return false;
        }
        String this$snapshotMode = this.getSnapshotMode();
        String other$snapshotMode = other.getSnapshotMode();
        if (this$snapshotMode == null ? other$snapshotMode != null : !this$snapshotMode.equals(other$snapshotMode)) {
            return false;
        }
        String this$offsetFilename = this.getOffsetFilename();
        String other$offsetFilename = other.getOffsetFilename();
        if (this$offsetFilename == null ? other$offsetFilename != null : !this$offsetFilename.equals(other$offsetFilename)) {
            return false;
        }
        String this$historyFilename = this.getHistoryFilename();
        String other$historyFilename = other.getHistoryFilename();
        if (this$historyFilename == null ? other$historyFilename != null : !this$historyFilename.equals(other$historyFilename)) {
            return false;
        }
        String this$monitoredDdl = this.getMonitoredDdl();
        String other$monitoredDdl = other.getMonitoredDdl();
        if (this$monitoredDdl == null ? other$monitoredDdl != null : !this$monitoredDdl.equals(other$monitoredDdl)) {
            return false;
        }
        String this$timestampFormatStandard = this.getTimestampFormatStandard();
        String other$timestampFormatStandard = other.getTimestampFormatStandard();
        if (this$timestampFormatStandard == null ? other$timestampFormatStandard != null : !this$timestampFormatStandard.equals(other$timestampFormatStandard)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MySQLBinlogSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isAllMigration() ? 79 : 97);
        Integer $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 43 : ((Object)$serverId).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $includeSchema = this.getIncludeSchema();
        result = result * 59 + ($includeSchema == null ? 43 : $includeSchema.hashCode());
        String $databaseWhiteList = this.getDatabaseWhiteList();
        result = result * 59 + ($databaseWhiteList == null ? 43 : $databaseWhiteList.hashCode());
        String $tableWhiteList = this.getTableWhiteList();
        result = result * 59 + ($tableWhiteList == null ? 43 : $tableWhiteList.hashCode());
        String $serverTimezone = this.getServerTimezone();
        result = result * 59 + ($serverTimezone == null ? 43 : $serverTimezone.hashCode());
        String $intervalMs = this.getIntervalMs();
        result = result * 59 + ($intervalMs == null ? 43 : $intervalMs.hashCode());
        String $snapshotMode = this.getSnapshotMode();
        result = result * 59 + ($snapshotMode == null ? 43 : $snapshotMode.hashCode());
        String $offsetFilename = this.getOffsetFilename();
        result = result * 59 + ($offsetFilename == null ? 43 : $offsetFilename.hashCode());
        String $historyFilename = this.getHistoryFilename();
        result = result * 59 + ($historyFilename == null ? 43 : $historyFilename.hashCode());
        String $monitoredDdl = this.getMonitoredDdl();
        result = result * 59 + ($monitoredDdl == null ? 43 : $monitoredDdl.hashCode());
        String $timestampFormatStandard = this.getTimestampFormatStandard();
        result = result * 59 + ($timestampFormatStandard == null ? 43 : $timestampFormatStandard.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    private static final class MySQLBinlogSourceBuilderImpl
    extends MySQLBinlogSourceBuilder<MySQLBinlogSource, MySQLBinlogSourceBuilderImpl> {
        private MySQLBinlogSourceBuilderImpl() {
        }

        @Override
        protected MySQLBinlogSourceBuilderImpl self() {
            return this;
        }

        @Override
        public MySQLBinlogSource build() {
            return new MySQLBinlogSource(this);
        }
    }

    public static abstract class MySQLBinlogSourceBuilder<C extends MySQLBinlogSource, B extends MySQLBinlogSourceBuilder<C, B>>
    extends StreamSource.StreamSourceBuilder<C, B> {
        private String user;
        private String password;
        private String hostname;
        private int port;
        private Integer serverId;
        private String includeSchema;
        private String databaseWhiteList;
        private String tableWhiteList;
        private String serverTimezone;
        private String intervalMs;
        private String snapshotMode;
        private String offsetFilename;
        private String historyFilename;
        private String monitoredDdl;
        private String timestampFormatStandard;
        private boolean allMigration;
        private String primaryKey;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B user(String user) {
            this.user = user;
            return (B)this.self();
        }

        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        public B hostname(String hostname) {
            this.hostname = hostname;
            return (B)this.self();
        }

        public B port(int port) {
            this.port = port;
            return (B)this.self();
        }

        public B serverId(Integer serverId) {
            this.serverId = serverId;
            return (B)this.self();
        }

        public B includeSchema(String includeSchema) {
            this.includeSchema = includeSchema;
            return (B)this.self();
        }

        public B databaseWhiteList(String databaseWhiteList) {
            this.databaseWhiteList = databaseWhiteList;
            return (B)this.self();
        }

        public B tableWhiteList(String tableWhiteList) {
            this.tableWhiteList = tableWhiteList;
            return (B)this.self();
        }

        public B serverTimezone(String serverTimezone) {
            this.serverTimezone = serverTimezone;
            return (B)this.self();
        }

        public B intervalMs(String intervalMs) {
            this.intervalMs = intervalMs;
            return (B)this.self();
        }

        public B snapshotMode(String snapshotMode) {
            this.snapshotMode = snapshotMode;
            return (B)this.self();
        }

        public B offsetFilename(String offsetFilename) {
            this.offsetFilename = offsetFilename;
            return (B)this.self();
        }

        public B historyFilename(String historyFilename) {
            this.historyFilename = historyFilename;
            return (B)this.self();
        }

        public B monitoredDdl(String monitoredDdl) {
            this.monitoredDdl = monitoredDdl;
            return (B)this.self();
        }

        public B timestampFormatStandard(String timestampFormatStandard) {
            this.timestampFormatStandard = timestampFormatStandard;
            return (B)this.self();
        }

        public B allMigration(boolean allMigration) {
            this.allMigration = allMigration;
            return (B)this.self();
        }

        public B primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "MySQLBinlogSource.MySQLBinlogSourceBuilder(super=" + super.toString() + ", user=" + this.user + ", password=" + this.password + ", hostname=" + this.hostname + ", port=" + this.port + ", serverId=" + this.serverId + ", includeSchema=" + this.includeSchema + ", databaseWhiteList=" + this.databaseWhiteList + ", tableWhiteList=" + this.tableWhiteList + ", serverTimezone=" + this.serverTimezone + ", intervalMs=" + this.intervalMs + ", snapshotMode=" + this.snapshotMode + ", offsetFilename=" + this.offsetFilename + ", historyFilename=" + this.historyFilename + ", monitoredDdl=" + this.monitoredDdl + ", timestampFormatStandard=" + this.timestampFormatStandard + ", allMigration=" + this.allMigration + ", primaryKey=" + this.primaryKey + ")";
        }
    }
}

