/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.mysql;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.source.mysql.MySQLBinlogSourceRequest;

public class MySQLBinlogSourceDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Username of the DB server")
    private String user;
    @ApiModelProperty(value="Password of the DB server")
    private String password;
    @ApiModelProperty(value="Hostname of the DB server")
    private String hostname;
    @ApiModelProperty(value="Exposed port of the DB server")
    private int port;
    @ApiModelProperty(value="Id of physical node of MySQL Cluster, 0 if single node")
    private Integer serverId;
    @ApiModelProperty(value="Whether include schema, default is 'false'")
    private String includeSchema;
    @ApiModelProperty(value="List of DBs to be collected, supporting regular expressions, seperated by ',', for example: db1,test_db*", notes="DBs not in this list are excluded. If not set, all DBs are monitored")
    private String databaseWhiteList;
    @ApiModelProperty(value="List of tables to be collected, supporting regular expressions, seperated by ',', for example: tb1,user*", notes="Tables not in this list are excluded. By default, all tables are monitored")
    private String tableWhiteList;
    @ApiModelProperty(value="Database time zone, Default is UTC")
    private String serverTimezone;
    @ApiModelProperty(value="The interval for recording an offset")
    private String intervalMs;
    @ApiModelProperty(value="Snapshot mode, supports: initial, when_needed, never, schema_only, schema_only_recovery")
    private String snapshotMode;
    @ApiModelProperty(value="The file path to store offset info")
    private String offsetFilename;
    @ApiModelProperty(value="The file path to store history info")
    private String historyFilename;
    @ApiModelProperty(value="Whether to monitor the DDL, default is 'false'")
    private String monitoredDdl;
    @ApiModelProperty(value="Timestamp standard for binlog: SQL, ISO_8601")
    private String timestampFormatStandard;
    @ApiModelProperty(value="Whether to migrate all databases")
    private boolean allMigration;
    @ApiModelProperty(value="Primary key must be shared by all tables", required=false)
    private String primaryKey;

    public static MySQLBinlogSourceDTO getFromRequest(MySQLBinlogSourceRequest request) {
        return MySQLBinlogSourceDTO.builder().user(request.getUser()).password(request.getPassword()).hostname(request.getHostname()).port(request.getPort()).serverId(request.getServerId()).includeSchema(request.getIncludeSchema()).databaseWhiteList(request.getDatabaseWhiteList()).tableWhiteList(request.getTableWhiteList()).serverTimezone(request.getServerTimezone()).intervalMs(request.getIntervalMs()).snapshotMode(request.getSnapshotMode()).offsetFilename(request.getOffsetFilename()).historyFilename(request.getHistoryFilename()).monitoredDdl(request.getMonitoredDdl()).allMigration(request.isAllMigration()).primaryKey(request.getPrimaryKey()).build();
    }

    public static MySQLBinlogSourceDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (MySQLBinlogSourceDTO)OBJECT_MAPPER.readValue(extParams, MySQLBinlogSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage());
        }
    }

    private static Integer $default$serverId() {
        return 0;
    }

    private static String $default$timestampFormatStandard() {
        return "SQL";
    }

    public static MySQLBinlogSourceDTOBuilder builder() {
        return new MySQLBinlogSourceDTOBuilder();
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public Integer getServerId() {
        return this.serverId;
    }

    public String getIncludeSchema() {
        return this.includeSchema;
    }

    public String getDatabaseWhiteList() {
        return this.databaseWhiteList;
    }

    public String getTableWhiteList() {
        return this.tableWhiteList;
    }

    public String getServerTimezone() {
        return this.serverTimezone;
    }

    public String getIntervalMs() {
        return this.intervalMs;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    public String getOffsetFilename() {
        return this.offsetFilename;
    }

    public String getHistoryFilename() {
        return this.historyFilename;
    }

    public String getMonitoredDdl() {
        return this.monitoredDdl;
    }

    public String getTimestampFormatStandard() {
        return this.timestampFormatStandard;
    }

    public boolean isAllMigration() {
        return this.allMigration;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setServerId(Integer serverId) {
        this.serverId = serverId;
    }

    public void setIncludeSchema(String includeSchema) {
        this.includeSchema = includeSchema;
    }

    public void setDatabaseWhiteList(String databaseWhiteList) {
        this.databaseWhiteList = databaseWhiteList;
    }

    public void setTableWhiteList(String tableWhiteList) {
        this.tableWhiteList = tableWhiteList;
    }

    public void setServerTimezone(String serverTimezone) {
        this.serverTimezone = serverTimezone;
    }

    public void setIntervalMs(String intervalMs) {
        this.intervalMs = intervalMs;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public void setOffsetFilename(String offsetFilename) {
        this.offsetFilename = offsetFilename;
    }

    public void setHistoryFilename(String historyFilename) {
        this.historyFilename = historyFilename;
    }

    public void setMonitoredDdl(String monitoredDdl) {
        this.monitoredDdl = monitoredDdl;
    }

    public void setTimestampFormatStandard(String timestampFormatStandard) {
        this.timestampFormatStandard = timestampFormatStandard;
    }

    public void setAllMigration(boolean allMigration) {
        this.allMigration = allMigration;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MySQLBinlogSourceDTO)) {
            return false;
        }
        MySQLBinlogSourceDTO other = (MySQLBinlogSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isAllMigration() != other.isAllMigration()) {
            return false;
        }
        Integer this$serverId = this.getServerId();
        Integer other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !((Object)this$serverId).equals(other$serverId)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$includeSchema = this.getIncludeSchema();
        String other$includeSchema = other.getIncludeSchema();
        if (this$includeSchema == null ? other$includeSchema != null : !this$includeSchema.equals(other$includeSchema)) {
            return false;
        }
        String this$databaseWhiteList = this.getDatabaseWhiteList();
        String other$databaseWhiteList = other.getDatabaseWhiteList();
        if (this$databaseWhiteList == null ? other$databaseWhiteList != null : !this$databaseWhiteList.equals(other$databaseWhiteList)) {
            return false;
        }
        String this$tableWhiteList = this.getTableWhiteList();
        String other$tableWhiteList = other.getTableWhiteList();
        if (this$tableWhiteList == null ? other$tableWhiteList != null : !this$tableWhiteList.equals(other$tableWhiteList)) {
            return false;
        }
        String this$serverTimezone = this.getServerTimezone();
        String other$serverTimezone = other.getServerTimezone();
        if (this$serverTimezone == null ? other$serverTimezone != null : !this$serverTimezone.equals(other$serverTimezone)) {
            return false;
        }
        String this$intervalMs = this.getIntervalMs();
        String other$intervalMs = other.getIntervalMs();
        if (this$intervalMs == null ? other$intervalMs != null : !this$intervalMs.equals(other$intervalMs)) {
            return false;
        }
        String this$snapshotMode = this.getSnapshotMode();
        String other$snapshotMode = other.getSnapshotMode();
        if (this$snapshotMode == null ? other$snapshotMode != null : !this$snapshotMode.equals(other$snapshotMode)) {
            return false;
        }
        String this$offsetFilename = this.getOffsetFilename();
        String other$offsetFilename = other.getOffsetFilename();
        if (this$offsetFilename == null ? other$offsetFilename != null : !this$offsetFilename.equals(other$offsetFilename)) {
            return false;
        }
        String this$historyFilename = this.getHistoryFilename();
        String other$historyFilename = other.getHistoryFilename();
        if (this$historyFilename == null ? other$historyFilename != null : !this$historyFilename.equals(other$historyFilename)) {
            return false;
        }
        String this$monitoredDdl = this.getMonitoredDdl();
        String other$monitoredDdl = other.getMonitoredDdl();
        if (this$monitoredDdl == null ? other$monitoredDdl != null : !this$monitoredDdl.equals(other$monitoredDdl)) {
            return false;
        }
        String this$timestampFormatStandard = this.getTimestampFormatStandard();
        String other$timestampFormatStandard = other.getTimestampFormatStandard();
        if (this$timestampFormatStandard == null ? other$timestampFormatStandard != null : !this$timestampFormatStandard.equals(other$timestampFormatStandard)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MySQLBinlogSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isAllMigration() ? 79 : 97);
        Integer $serverId = this.getServerId();
        result = result * 59 + ($serverId == null ? 43 : ((Object)$serverId).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $includeSchema = this.getIncludeSchema();
        result = result * 59 + ($includeSchema == null ? 43 : $includeSchema.hashCode());
        String $databaseWhiteList = this.getDatabaseWhiteList();
        result = result * 59 + ($databaseWhiteList == null ? 43 : $databaseWhiteList.hashCode());
        String $tableWhiteList = this.getTableWhiteList();
        result = result * 59 + ($tableWhiteList == null ? 43 : $tableWhiteList.hashCode());
        String $serverTimezone = this.getServerTimezone();
        result = result * 59 + ($serverTimezone == null ? 43 : $serverTimezone.hashCode());
        String $intervalMs = this.getIntervalMs();
        result = result * 59 + ($intervalMs == null ? 43 : $intervalMs.hashCode());
        String $snapshotMode = this.getSnapshotMode();
        result = result * 59 + ($snapshotMode == null ? 43 : $snapshotMode.hashCode());
        String $offsetFilename = this.getOffsetFilename();
        result = result * 59 + ($offsetFilename == null ? 43 : $offsetFilename.hashCode());
        String $historyFilename = this.getHistoryFilename();
        result = result * 59 + ($historyFilename == null ? 43 : $historyFilename.hashCode());
        String $monitoredDdl = this.getMonitoredDdl();
        result = result * 59 + ($monitoredDdl == null ? 43 : $monitoredDdl.hashCode());
        String $timestampFormatStandard = this.getTimestampFormatStandard();
        result = result * 59 + ($timestampFormatStandard == null ? 43 : $timestampFormatStandard.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    public String toString() {
        return "MySQLBinlogSourceDTO(user=" + this.getUser() + ", password=" + this.getPassword() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", serverId=" + this.getServerId() + ", includeSchema=" + this.getIncludeSchema() + ", databaseWhiteList=" + this.getDatabaseWhiteList() + ", tableWhiteList=" + this.getTableWhiteList() + ", serverTimezone=" + this.getServerTimezone() + ", intervalMs=" + this.getIntervalMs() + ", snapshotMode=" + this.getSnapshotMode() + ", offsetFilename=" + this.getOffsetFilename() + ", historyFilename=" + this.getHistoryFilename() + ", monitoredDdl=" + this.getMonitoredDdl() + ", timestampFormatStandard=" + this.getTimestampFormatStandard() + ", allMigration=" + this.isAllMigration() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    public MySQLBinlogSourceDTO() {
        this.serverId = MySQLBinlogSourceDTO.$default$serverId();
        this.timestampFormatStandard = MySQLBinlogSourceDTO.$default$timestampFormatStandard();
    }

    public MySQLBinlogSourceDTO(String user, String password, String hostname, int port, Integer serverId, String includeSchema, String databaseWhiteList, String tableWhiteList, String serverTimezone, String intervalMs, String snapshotMode, String offsetFilename, String historyFilename, String monitoredDdl, String timestampFormatStandard, boolean allMigration, String primaryKey) {
        this.user = user;
        this.password = password;
        this.hostname = hostname;
        this.port = port;
        this.serverId = serverId;
        this.includeSchema = includeSchema;
        this.databaseWhiteList = databaseWhiteList;
        this.tableWhiteList = tableWhiteList;
        this.serverTimezone = serverTimezone;
        this.intervalMs = intervalMs;
        this.snapshotMode = snapshotMode;
        this.offsetFilename = offsetFilename;
        this.historyFilename = historyFilename;
        this.monitoredDdl = monitoredDdl;
        this.timestampFormatStandard = timestampFormatStandard;
        this.allMigration = allMigration;
        this.primaryKey = primaryKey;
    }

    public static class MySQLBinlogSourceDTOBuilder {
        private String user;
        private String password;
        private String hostname;
        private int port;
        private boolean serverId$set;
        private Integer serverId$value;
        private String includeSchema;
        private String databaseWhiteList;
        private String tableWhiteList;
        private String serverTimezone;
        private String intervalMs;
        private String snapshotMode;
        private String offsetFilename;
        private String historyFilename;
        private String monitoredDdl;
        private boolean timestampFormatStandard$set;
        private String timestampFormatStandard$value;
        private boolean allMigration;
        private String primaryKey;

        MySQLBinlogSourceDTOBuilder() {
        }

        public MySQLBinlogSourceDTOBuilder user(String user) {
            this.user = user;
            return this;
        }

        public MySQLBinlogSourceDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public MySQLBinlogSourceDTOBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public MySQLBinlogSourceDTOBuilder port(int port) {
            this.port = port;
            return this;
        }

        public MySQLBinlogSourceDTOBuilder serverId(Integer serverId) {
            this.serverId$value = serverId;
            this.serverId$set = true;
            return this;
        }

        public MySQLBinlogSourceDTOBuilder includeSchema(String includeSchema) {
            this.includeSchema = includeSchema;
            return this;
        }

        public MySQLBinlogSourceDTOBuilder databaseWhiteList(String databaseWhiteList) {
            this.databaseWhiteList = databaseWhiteList;
            return this;
        }

        public MySQLBinlogSourceDTOBuilder tableWhiteList(String tableWhiteList) {
            this.tableWhiteList = tableWhiteList;
            return this;
        }

        public MySQLBinlogSourceDTOBuilder serverTimezone(String serverTimezone) {
            this.serverTimezone = serverTimezone;
            return this;
        }

        public MySQLBinlogSourceDTOBuilder intervalMs(String intervalMs) {
            this.intervalMs = intervalMs;
            return this;
        }

        public MySQLBinlogSourceDTOBuilder snapshotMode(String snapshotMode) {
            this.snapshotMode = snapshotMode;
            return this;
        }

        public MySQLBinlogSourceDTOBuilder offsetFilename(String offsetFilename) {
            this.offsetFilename = offsetFilename;
            return this;
        }

        public MySQLBinlogSourceDTOBuilder historyFilename(String historyFilename) {
            this.historyFilename = historyFilename;
            return this;
        }

        public MySQLBinlogSourceDTOBuilder monitoredDdl(String monitoredDdl) {
            this.monitoredDdl = monitoredDdl;
            return this;
        }

        public MySQLBinlogSourceDTOBuilder timestampFormatStandard(String timestampFormatStandard) {
            this.timestampFormatStandard$value = timestampFormatStandard;
            this.timestampFormatStandard$set = true;
            return this;
        }

        public MySQLBinlogSourceDTOBuilder allMigration(boolean allMigration) {
            this.allMigration = allMigration;
            return this;
        }

        public MySQLBinlogSourceDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public MySQLBinlogSourceDTO build() {
            Integer serverId$value = this.serverId$value;
            if (!this.serverId$set) {
                serverId$value = MySQLBinlogSourceDTO.$default$serverId();
            }
            String timestampFormatStandard$value = this.timestampFormatStandard$value;
            if (!this.timestampFormatStandard$set) {
                timestampFormatStandard$value = MySQLBinlogSourceDTO.$default$timestampFormatStandard();
            }
            return new MySQLBinlogSourceDTO(this.user, this.password, this.hostname, this.port, serverId$value, this.includeSchema, this.databaseWhiteList, this.tableWhiteList, this.serverTimezone, this.intervalMs, this.snapshotMode, this.offsetFilename, this.historyFilename, this.monitoredDdl, timestampFormatStandard$value, this.allMigration, this.primaryKey);
        }

        public String toString() {
            return "MySQLBinlogSourceDTO.MySQLBinlogSourceDTOBuilder(user=" + this.user + ", password=" + this.password + ", hostname=" + this.hostname + ", port=" + this.port + ", serverId$value=" + this.serverId$value + ", includeSchema=" + this.includeSchema + ", databaseWhiteList=" + this.databaseWhiteList + ", tableWhiteList=" + this.tableWhiteList + ", serverTimezone=" + this.serverTimezone + ", intervalMs=" + this.intervalMs + ", snapshotMode=" + this.snapshotMode + ", offsetFilename=" + this.offsetFilename + ", historyFilename=" + this.historyFilename + ", monitoredDdl=" + this.monitoredDdl + ", timestampFormatStandard$value=" + this.timestampFormatStandard$value + ", allMigration=" + this.allMigration + ", primaryKey=" + this.primaryKey + ")";
        }
    }
}

