/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.oracle;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.pojo.source.SourceRequest;
import org.apache.inlong.manager.common.pojo.source.StreamSource;
import org.apache.inlong.manager.common.pojo.source.oracle.OracleSourceRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;

@ApiModel(value="Oracle source info")
@JsonTypeDefine(value="ORACLE")
public class OracleSource
extends StreamSource {
    @ApiModelProperty(value="Hostname of the DB server, for example: 127.0.0.1")
    private String hostname;
    @ApiModelProperty(value="Exposed port of the DB server")
    private Integer port = 1521;
    @ApiModelProperty(value="Username of the DB server")
    private String username;
    @ApiModelProperty(value="Password of the DB server")
    private String password;
    @ApiModelProperty(value="Database name")
    private String database;
    @ApiModelProperty(value="Schema name")
    private String schemaName;
    @ApiModelProperty(value="table name")
    private String tableName;
    @ApiModelProperty(value="Scan startup mode")
    private String scanStartupMode;
    @ApiModelProperty(value="Primary key must be shared by all tables")
    private String primaryKey;
    @ApiModelProperty(value="Need transfer total database")
    private boolean allMigration = false;

    public OracleSource() {
        this.setSourceType(SourceType.ORACLE.name());
    }

    @Override
    public SourceRequest genSourceRequest() {
        return CommonBeanUtils.copyProperties(this, OracleSourceRequest::new);
    }

    protected OracleSource(OracleSourceBuilder<?, ?> b) {
        super((StreamSource.StreamSourceBuilder<?, ?>)b);
        this.hostname = ((OracleSourceBuilder)b).hostname;
        this.port = ((OracleSourceBuilder)b).port;
        this.username = ((OracleSourceBuilder)b).username;
        this.password = ((OracleSourceBuilder)b).password;
        this.database = ((OracleSourceBuilder)b).database;
        this.schemaName = ((OracleSourceBuilder)b).schemaName;
        this.tableName = ((OracleSourceBuilder)b).tableName;
        this.scanStartupMode = ((OracleSourceBuilder)b).scanStartupMode;
        this.primaryKey = ((OracleSourceBuilder)b).primaryKey;
        this.allMigration = ((OracleSourceBuilder)b).allMigration;
    }

    public static OracleSourceBuilder<?, ?> builder() {
        return new OracleSourceBuilderImpl();
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getScanStartupMode() {
        return this.scanStartupMode;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isAllMigration() {
        return this.allMigration;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setScanStartupMode(String scanStartupMode) {
        this.scanStartupMode = scanStartupMode;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setAllMigration(boolean allMigration) {
        this.allMigration = allMigration;
    }

    public OracleSource(String hostname, Integer port, String username, String password, String database, String schemaName, String tableName, String scanStartupMode, String primaryKey, boolean allMigration) {
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
        this.database = database;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.scanStartupMode = scanStartupMode;
        this.primaryKey = primaryKey;
        this.allMigration = allMigration;
    }

    @Override
    public String toString() {
        return "OracleSource(super=" + super.toString() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ", scanStartupMode=" + this.getScanStartupMode() + ", primaryKey=" + this.getPrimaryKey() + ", allMigration=" + this.isAllMigration() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OracleSource)) {
            return false;
        }
        OracleSource other = (OracleSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAllMigration() != other.isAllMigration()) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$scanStartupMode = this.getScanStartupMode();
        String other$scanStartupMode = other.getScanStartupMode();
        if (this$scanStartupMode == null ? other$scanStartupMode != null : !this$scanStartupMode.equals(other$scanStartupMode)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OracleSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAllMigration() ? 79 : 97);
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $scanStartupMode = this.getScanStartupMode();
        result = result * 59 + ($scanStartupMode == null ? 43 : $scanStartupMode.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    private static final class OracleSourceBuilderImpl
    extends OracleSourceBuilder<OracleSource, OracleSourceBuilderImpl> {
        private OracleSourceBuilderImpl() {
        }

        @Override
        protected OracleSourceBuilderImpl self() {
            return this;
        }

        @Override
        public OracleSource build() {
            return new OracleSource(this);
        }
    }

    public static abstract class OracleSourceBuilder<C extends OracleSource, B extends OracleSourceBuilder<C, B>>
    extends StreamSource.StreamSourceBuilder<C, B> {
        private String hostname;
        private Integer port;
        private String username;
        private String password;
        private String database;
        private String schemaName;
        private String tableName;
        private String scanStartupMode;
        private String primaryKey;
        private boolean allMigration;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B hostname(String hostname) {
            this.hostname = hostname;
            return (B)this.self();
        }

        public B port(Integer port) {
            this.port = port;
            return (B)this.self();
        }

        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        public B password(String password) {
            this.password = password;
            return (B)this.self();
        }

        public B database(String database) {
            this.database = database;
            return (B)this.self();
        }

        public B schemaName(String schemaName) {
            this.schemaName = schemaName;
            return (B)this.self();
        }

        public B tableName(String tableName) {
            this.tableName = tableName;
            return (B)this.self();
        }

        public B scanStartupMode(String scanStartupMode) {
            this.scanStartupMode = scanStartupMode;
            return (B)this.self();
        }

        public B primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return (B)this.self();
        }

        public B allMigration(boolean allMigration) {
            this.allMigration = allMigration;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "OracleSource.OracleSourceBuilder(super=" + super.toString() + ", hostname=" + this.hostname + ", port=" + this.port + ", username=" + this.username + ", password=" + this.password + ", database=" + this.database + ", schemaName=" + this.schemaName + ", tableName=" + this.tableName + ", scanStartupMode=" + this.scanStartupMode + ", primaryKey=" + this.primaryKey + ", allMigration=" + this.allMigration + ")";
        }
    }
}

