/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.oracle;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.source.oracle.OracleSourceRequest;

public class OracleSourceDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Hostname of the DB server, for example: 127.0.0.1")
    private String hostname;
    @ApiModelProperty(value="Exposed port of the DB server")
    private Integer port = 1521;
    @ApiModelProperty(value="Username of the DB server")
    private String username;
    @ApiModelProperty(value="Password of the DB server")
    private String password;
    @ApiModelProperty(value="Database name")
    private String database;
    @ApiModelProperty(value="Schema name")
    private String schemaName;
    @ApiModelProperty(value="table name")
    private String tableName;
    @ApiModelProperty(value="Scan startup mode")
    private String scanStartupMode;
    @ApiModelProperty(value="Primary key must be shared by all tables")
    private String primaryKey;

    public static OracleSourceDTO getFromRequest(OracleSourceRequest request) {
        return OracleSourceDTO.builder().database(request.getDatabase()).hostname(request.getHostname()).port(request.getPort()).username(request.getUsername()).password(request.getPassword()).schemaName(request.getSchemaName()).tableName(request.getTableName()).primaryKey(request.getPrimaryKey()).scanStartupMode(request.getScanStartupMode()).build();
    }

    public static OracleSourceDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (OracleSourceDTO)OBJECT_MAPPER.readValue(extParams, OracleSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage());
        }
    }

    public static OracleSourceDTOBuilder builder() {
        return new OracleSourceDTOBuilder();
    }

    public String getHostname() {
        return this.hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getScanStartupMode() {
        return this.scanStartupMode;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setScanStartupMode(String scanStartupMode) {
        this.scanStartupMode = scanStartupMode;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OracleSourceDTO)) {
            return false;
        }
        OracleSourceDTO other = (OracleSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$scanStartupMode = this.getScanStartupMode();
        String other$scanStartupMode = other.getScanStartupMode();
        if (this$scanStartupMode == null ? other$scanStartupMode != null : !this$scanStartupMode.equals(other$scanStartupMode)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OracleSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $scanStartupMode = this.getScanStartupMode();
        result = result * 59 + ($scanStartupMode == null ? 43 : $scanStartupMode.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    public String toString() {
        return "OracleSourceDTO(hostname=" + this.getHostname() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ", scanStartupMode=" + this.getScanStartupMode() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    public OracleSourceDTO() {
    }

    public OracleSourceDTO(String hostname, Integer port, String username, String password, String database, String schemaName, String tableName, String scanStartupMode, String primaryKey) {
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
        this.database = database;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.scanStartupMode = scanStartupMode;
        this.primaryKey = primaryKey;
    }

    public static class OracleSourceDTOBuilder {
        private String hostname;
        private Integer port;
        private String username;
        private String password;
        private String database;
        private String schemaName;
        private String tableName;
        private String scanStartupMode;
        private String primaryKey;

        OracleSourceDTOBuilder() {
        }

        public OracleSourceDTOBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public OracleSourceDTOBuilder port(Integer port) {
            this.port = port;
            return this;
        }

        public OracleSourceDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public OracleSourceDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public OracleSourceDTOBuilder database(String database) {
            this.database = database;
            return this;
        }

        public OracleSourceDTOBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public OracleSourceDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public OracleSourceDTOBuilder scanStartupMode(String scanStartupMode) {
            this.scanStartupMode = scanStartupMode;
            return this;
        }

        public OracleSourceDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public OracleSourceDTO build() {
            return new OracleSourceDTO(this.hostname, this.port, this.username, this.password, this.database, this.schemaName, this.tableName, this.scanStartupMode, this.primaryKey);
        }

        public String toString() {
            return "OracleSourceDTO.OracleSourceDTOBuilder(hostname=" + this.hostname + ", port=" + this.port + ", username=" + this.username + ", password=" + this.password + ", database=" + this.database + ", schemaName=" + this.schemaName + ", tableName=" + this.tableName + ", scanStartupMode=" + this.scanStartupMode + ", primaryKey=" + this.primaryKey + ")";
        }
    }
}

