/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.postgres;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.source.postgres.PostgresSourceRequest;

public class PostgresSourceDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Primary key")
    private String primaryKey;
    @ApiModelProperty(value="Username of the DB server")
    private String username;
    @ApiModelProperty(value="Password of the DB server")
    private String password;
    @ApiModelProperty(value="Hostname of the DB server")
    private String hostname;
    @ApiModelProperty(value="Exposed port of the DB server")
    private int port;
    @ApiModelProperty(value="Exposed database of the DB")
    private String database;
    @ApiModelProperty(value="Schema info")
    private String schema;
    @ApiModelProperty(value="Decoding plugin name")
    private String decodingPluginName;
    @ApiModelProperty(value="List of tables name")
    private List<String> tableNameList;

    public static PostgresSourceDTO getFromRequest(PostgresSourceRequest request) {
        return PostgresSourceDTO.builder().username(request.getUsername()).password(request.getPassword()).hostname(request.getHostname()).port(request.getPort()).schema(request.getSchema()).database(request.getDatabase()).tableNameList(request.getTableNameList()).primaryKey(request.getPrimaryKey()).decodingPluginName(request.getDecodingPluginName()).build();
    }

    public static PostgresSourceDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (PostgresSourceDTO)OBJECT_MAPPER.readValue(extParams, PostgresSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage());
        }
    }

    public static PostgresSourceDTOBuilder builder() {
        return new PostgresSourceDTOBuilder();
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDecodingPluginName() {
        return this.decodingPluginName;
    }

    public List<String> getTableNameList() {
        return this.tableNameList;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setDecodingPluginName(String decodingPluginName) {
        this.decodingPluginName = decodingPluginName;
    }

    public void setTableNameList(List<String> tableNameList) {
        this.tableNameList = tableNameList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostgresSourceDTO)) {
            return false;
        }
        PostgresSourceDTO other = (PostgresSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$decodingPluginName = this.getDecodingPluginName();
        String other$decodingPluginName = other.getDecodingPluginName();
        if (this$decodingPluginName == null ? other$decodingPluginName != null : !this$decodingPluginName.equals(other$decodingPluginName)) {
            return false;
        }
        List<String> this$tableNameList = this.getTableNameList();
        List<String> other$tableNameList = other.getTableNameList();
        return !(this$tableNameList == null ? other$tableNameList != null : !((Object)this$tableNameList).equals(other$tableNameList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PostgresSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $decodingPluginName = this.getDecodingPluginName();
        result = result * 59 + ($decodingPluginName == null ? 43 : $decodingPluginName.hashCode());
        List<String> $tableNameList = this.getTableNameList();
        result = result * 59 + ($tableNameList == null ? 43 : ((Object)$tableNameList).hashCode());
        return result;
    }

    public String toString() {
        return "PostgresSourceDTO(primaryKey=" + this.getPrimaryKey() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", schema=" + this.getSchema() + ", decodingPluginName=" + this.getDecodingPluginName() + ", tableNameList=" + this.getTableNameList() + ")";
    }

    public PostgresSourceDTO() {
    }

    public PostgresSourceDTO(String primaryKey, String username, String password, String hostname, int port, String database, String schema, String decodingPluginName, List<String> tableNameList) {
        this.primaryKey = primaryKey;
        this.username = username;
        this.password = password;
        this.hostname = hostname;
        this.port = port;
        this.database = database;
        this.schema = schema;
        this.decodingPluginName = decodingPluginName;
        this.tableNameList = tableNameList;
    }

    public static class PostgresSourceDTOBuilder {
        private String primaryKey;
        private String username;
        private String password;
        private String hostname;
        private int port;
        private String database;
        private String schema;
        private String decodingPluginName;
        private List<String> tableNameList;

        PostgresSourceDTOBuilder() {
        }

        public PostgresSourceDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public PostgresSourceDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public PostgresSourceDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public PostgresSourceDTOBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public PostgresSourceDTOBuilder port(int port) {
            this.port = port;
            return this;
        }

        public PostgresSourceDTOBuilder database(String database) {
            this.database = database;
            return this;
        }

        public PostgresSourceDTOBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public PostgresSourceDTOBuilder decodingPluginName(String decodingPluginName) {
            this.decodingPluginName = decodingPluginName;
            return this;
        }

        public PostgresSourceDTOBuilder tableNameList(List<String> tableNameList) {
            this.tableNameList = tableNameList;
            return this;
        }

        public PostgresSourceDTO build() {
            return new PostgresSourceDTO(this.primaryKey, this.username, this.password, this.hostname, this.port, this.database, this.schema, this.decodingPluginName, this.tableNameList);
        }

        public String toString() {
            return "PostgresSourceDTO.PostgresSourceDTOBuilder(primaryKey=" + this.primaryKey + ", username=" + this.username + ", password=" + this.password + ", hostname=" + this.hostname + ", port=" + this.port + ", database=" + this.database + ", schema=" + this.schema + ", decodingPluginName=" + this.decodingPluginName + ", tableNameList=" + this.tableNameList + ")";
        }
    }
}

