/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.pulsar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.pojo.source.SourceRequest;
import org.apache.inlong.manager.common.pojo.source.StreamSource;
import org.apache.inlong.manager.common.pojo.source.pulsar.PulsarSourceRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;

@ApiModel(value="Pulsar source info")
@JsonTypeDefine(value="PULSAR")
public class PulsarSource
extends StreamSource {
    @ApiModelProperty(value="Pulsar tenant")
    private String tenant = "public";
    @ApiModelProperty(value="Pulsar namespace")
    private String namespace;
    @ApiModelProperty(value="Pulsar topic")
    private String topic;
    @ApiModelProperty(value="Pulsar adminUrl")
    private String adminUrl;
    @ApiModelProperty(value="Pulsar serviceUrl")
    private String serviceUrl;
    @ApiModelProperty(value="Primary key, needed when serialization type is csv, json, avro")
    private String primaryKey;
    @ApiModelProperty(value="Configure the Source's startup mode. Available options are earliest, latest, external-subscription, and specific-offsets.")
    private String scanStartupMode = "earliest";
    private boolean isInlongComponent = false;

    public PulsarSource() {
        this.setSourceType(SourceType.PULSAR.getType());
    }

    @Override
    public SourceRequest genSourceRequest() {
        return CommonBeanUtils.copyProperties(this, PulsarSourceRequest::new);
    }

    protected PulsarSource(PulsarSourceBuilder<?, ?> b) {
        super((StreamSource.StreamSourceBuilder<?, ?>)b);
        this.tenant = ((PulsarSourceBuilder)b).tenant;
        this.namespace = ((PulsarSourceBuilder)b).namespace;
        this.topic = ((PulsarSourceBuilder)b).topic;
        this.adminUrl = ((PulsarSourceBuilder)b).adminUrl;
        this.serviceUrl = ((PulsarSourceBuilder)b).serviceUrl;
        this.primaryKey = ((PulsarSourceBuilder)b).primaryKey;
        this.scanStartupMode = ((PulsarSourceBuilder)b).scanStartupMode;
        this.isInlongComponent = ((PulsarSourceBuilder)b).isInlongComponent;
    }

    public static PulsarSourceBuilder<?, ?> builder() {
        return new PulsarSourceBuilderImpl();
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getScanStartupMode() {
        return this.scanStartupMode;
    }

    public boolean isInlongComponent() {
        return this.isInlongComponent;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setScanStartupMode(String scanStartupMode) {
        this.scanStartupMode = scanStartupMode;
    }

    public void setInlongComponent(boolean isInlongComponent) {
        this.isInlongComponent = isInlongComponent;
    }

    public PulsarSource(String tenant, String namespace, String topic, String adminUrl, String serviceUrl, String primaryKey, String scanStartupMode, boolean isInlongComponent) {
        this.tenant = tenant;
        this.namespace = namespace;
        this.topic = topic;
        this.adminUrl = adminUrl;
        this.serviceUrl = serviceUrl;
        this.primaryKey = primaryKey;
        this.scanStartupMode = scanStartupMode;
        this.isInlongComponent = isInlongComponent;
    }

    @Override
    public String toString() {
        return "PulsarSource(super=" + super.toString() + ", tenant=" + this.getTenant() + ", namespace=" + this.getNamespace() + ", topic=" + this.getTopic() + ", adminUrl=" + this.getAdminUrl() + ", serviceUrl=" + this.getServiceUrl() + ", primaryKey=" + this.getPrimaryKey() + ", scanStartupMode=" + this.getScanStartupMode() + ", isInlongComponent=" + this.isInlongComponent() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarSource)) {
            return false;
        }
        PulsarSource other = (PulsarSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isInlongComponent() != other.isInlongComponent()) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$adminUrl = this.getAdminUrl();
        String other$adminUrl = other.getAdminUrl();
        if (this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$scanStartupMode = this.getScanStartupMode();
        String other$scanStartupMode = other.getScanStartupMode();
        return !(this$scanStartupMode == null ? other$scanStartupMode != null : !this$scanStartupMode.equals(other$scanStartupMode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PulsarSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isInlongComponent() ? 79 : 97);
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $adminUrl = this.getAdminUrl();
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $scanStartupMode = this.getScanStartupMode();
        result = result * 59 + ($scanStartupMode == null ? 43 : $scanStartupMode.hashCode());
        return result;
    }

    private static final class PulsarSourceBuilderImpl
    extends PulsarSourceBuilder<PulsarSource, PulsarSourceBuilderImpl> {
        private PulsarSourceBuilderImpl() {
        }

        @Override
        protected PulsarSourceBuilderImpl self() {
            return this;
        }

        @Override
        public PulsarSource build() {
            return new PulsarSource(this);
        }
    }

    public static abstract class PulsarSourceBuilder<C extends PulsarSource, B extends PulsarSourceBuilder<C, B>>
    extends StreamSource.StreamSourceBuilder<C, B> {
        private String tenant;
        private String namespace;
        private String topic;
        private String adminUrl;
        private String serviceUrl;
        private String primaryKey;
        private String scanStartupMode;
        private boolean isInlongComponent;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B tenant(String tenant) {
            this.tenant = tenant;
            return (B)this.self();
        }

        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        public B topic(String topic) {
            this.topic = topic;
            return (B)this.self();
        }

        public B adminUrl(String adminUrl) {
            this.adminUrl = adminUrl;
            return (B)this.self();
        }

        public B serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return (B)this.self();
        }

        public B primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return (B)this.self();
        }

        public B scanStartupMode(String scanStartupMode) {
            this.scanStartupMode = scanStartupMode;
            return (B)this.self();
        }

        public B isInlongComponent(boolean isInlongComponent) {
            this.isInlongComponent = isInlongComponent;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "PulsarSource.PulsarSourceBuilder(super=" + super.toString() + ", tenant=" + this.tenant + ", namespace=" + this.namespace + ", topic=" + this.topic + ", adminUrl=" + this.adminUrl + ", serviceUrl=" + this.serviceUrl + ", primaryKey=" + this.primaryKey + ", scanStartupMode=" + this.scanStartupMode + ", isInlongComponent=" + this.isInlongComponent + ")";
        }
    }
}

