/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.pulsar;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.source.pulsar.PulsarSourceRequest;

public class PulsarSourceDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Pulsar tenant")
    private String tenant;
    @ApiModelProperty(value="Pulsar namespace")
    private String namespace;
    @ApiModelProperty(value="Pulsar topic")
    private String topic;
    @ApiModelProperty(value="Pulsar adminUrl")
    private String adminUrl;
    @ApiModelProperty(value="Pulsar serviceUrl")
    private String serviceUrl;
    @ApiModelProperty(value="Primary key, needed when serialization type is csv, json, avro")
    private String primaryKey;
    @ApiModelProperty(value="Configure the Source's startup mode. Available options are earliest, latest, external-subscription, and specific-offsets.")
    private String scanStartupMode;

    public static PulsarSourceDTO getFromRequest(PulsarSourceRequest request) {
        return PulsarSourceDTO.builder().adminUrl(request.getAdminUrl()).serviceUrl(request.getServiceUrl()).tenant(request.getTenant()).namespace(request.getNamespace()).topic(request.getTopic()).primaryKey(request.getPrimaryKey()).scanStartupMode(request.getScanStartupMode()).build();
    }

    public static PulsarSourceDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (PulsarSourceDTO)OBJECT_MAPPER.readValue(extParams, PulsarSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage());
        }
    }

    private static String $default$scanStartupMode() {
        return "earliest";
    }

    public static PulsarSourceDTOBuilder builder() {
        return new PulsarSourceDTOBuilder();
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public String getScanStartupMode() {
        return this.scanStartupMode;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setScanStartupMode(String scanStartupMode) {
        this.scanStartupMode = scanStartupMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarSourceDTO)) {
            return false;
        }
        PulsarSourceDTO other = (PulsarSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$adminUrl = this.getAdminUrl();
        String other$adminUrl = other.getAdminUrl();
        if (this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$scanStartupMode = this.getScanStartupMode();
        String other$scanStartupMode = other.getScanStartupMode();
        return !(this$scanStartupMode == null ? other$scanStartupMode != null : !this$scanStartupMode.equals(other$scanStartupMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PulsarSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $adminUrl = this.getAdminUrl();
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $scanStartupMode = this.getScanStartupMode();
        result = result * 59 + ($scanStartupMode == null ? 43 : $scanStartupMode.hashCode());
        return result;
    }

    public String toString() {
        return "PulsarSourceDTO(tenant=" + this.getTenant() + ", namespace=" + this.getNamespace() + ", topic=" + this.getTopic() + ", adminUrl=" + this.getAdminUrl() + ", serviceUrl=" + this.getServiceUrl() + ", primaryKey=" + this.getPrimaryKey() + ", scanStartupMode=" + this.getScanStartupMode() + ")";
    }

    public PulsarSourceDTO(String tenant, String namespace, String topic, String adminUrl, String serviceUrl, String primaryKey, String scanStartupMode) {
        this.tenant = tenant;
        this.namespace = namespace;
        this.topic = topic;
        this.adminUrl = adminUrl;
        this.serviceUrl = serviceUrl;
        this.primaryKey = primaryKey;
        this.scanStartupMode = scanStartupMode;
    }

    public PulsarSourceDTO() {
        this.scanStartupMode = PulsarSourceDTO.$default$scanStartupMode();
    }

    public static class PulsarSourceDTOBuilder {
        private String tenant;
        private String namespace;
        private String topic;
        private String adminUrl;
        private String serviceUrl;
        private String primaryKey;
        private boolean scanStartupMode$set;
        private String scanStartupMode$value;

        PulsarSourceDTOBuilder() {
        }

        public PulsarSourceDTOBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public PulsarSourceDTOBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PulsarSourceDTOBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public PulsarSourceDTOBuilder adminUrl(String adminUrl) {
            this.adminUrl = adminUrl;
            return this;
        }

        public PulsarSourceDTOBuilder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public PulsarSourceDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public PulsarSourceDTOBuilder scanStartupMode(String scanStartupMode) {
            this.scanStartupMode$value = scanStartupMode;
            this.scanStartupMode$set = true;
            return this;
        }

        public PulsarSourceDTO build() {
            String scanStartupMode$value = this.scanStartupMode$value;
            if (!this.scanStartupMode$set) {
                scanStartupMode$value = PulsarSourceDTO.$default$scanStartupMode();
            }
            return new PulsarSourceDTO(this.tenant, this.namespace, this.topic, this.adminUrl, this.serviceUrl, this.primaryKey, scanStartupMode$value);
        }

        public String toString() {
            return "PulsarSourceDTO.PulsarSourceDTOBuilder(tenant=" + this.tenant + ", namespace=" + this.namespace + ", topic=" + this.topic + ", adminUrl=" + this.adminUrl + ", serviceUrl=" + this.serviceUrl + ", primaryKey=" + this.primaryKey + ", scanStartupMode$value=" + this.scanStartupMode$value + ")";
        }
    }
}

