/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.source.sqlserver;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.source.sqlserver.SqlServerSourceRequest;

public class SqlServerSourceDTO {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @ApiModelProperty(value="Username of the SqlServer")
    private String username;
    @ApiModelProperty(value="Password of the SqlServer")
    private String password;
    @ApiModelProperty(value="Hostname of the SqlServer")
    private String hostname;
    @ApiModelProperty(value="Exposed port of the SqlServer")
    private int port;
    @ApiModelProperty(value="Database of the SqlServer")
    private String database;
    @ApiModelProperty(value="Schema name of the SqlServer")
    private String schemaName;
    @ApiModelProperty(value="Table name of the SqlServer")
    private String tableName;
    @ApiModelProperty(value="Database time zone, default is UTC")
    private String serverTimezone;
    @ApiModelProperty(value="Whether to migrate all databases")
    private boolean allMigration;
    @ApiModelProperty(value="Primary key must be shared by all tables")
    private String primaryKey;

    public static SqlServerSourceDTO getFromRequest(SqlServerSourceRequest request) {
        return SqlServerSourceDTO.builder().username(request.getUsername()).password(request.getPassword()).hostname(request.getHostname()).port(request.getPort()).database(request.getDatabase()).schemaName(request.getSchemaName()).tableName(request.getTableName()).serverTimezone(request.getServerTimezone()).allMigration(request.isAllMigration()).primaryKey(request.getPrimaryKey()).build();
    }

    public static SqlServerSourceDTO getFromJson(@NotNull String extParams) {
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (SqlServerSourceDTO)OBJECT_MAPPER.readValue(extParams, SqlServerSourceDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage());
        }
    }

    public static SqlServerSourceDTOBuilder builder() {
        return new SqlServerSourceDTOBuilder();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getServerTimezone() {
        return this.serverTimezone;
    }

    public boolean isAllMigration() {
        return this.allMigration;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setServerTimezone(String serverTimezone) {
        this.serverTimezone = serverTimezone;
    }

    public void setAllMigration(boolean allMigration) {
        this.allMigration = allMigration;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlServerSourceDTO)) {
            return false;
        }
        SqlServerSourceDTO other = (SqlServerSourceDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isAllMigration() != other.isAllMigration()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$serverTimezone = this.getServerTimezone();
        String other$serverTimezone = other.getServerTimezone();
        if (this$serverTimezone == null ? other$serverTimezone != null : !this$serverTimezone.equals(other$serverTimezone)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqlServerSourceDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isAllMigration() ? 79 : 97);
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $serverTimezone = this.getServerTimezone();
        result = result * 59 + ($serverTimezone == null ? 43 : $serverTimezone.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }

    public String toString() {
        return "SqlServerSourceDTO(username=" + this.getUsername() + ", password=" + this.getPassword() + ", hostname=" + this.getHostname() + ", port=" + this.getPort() + ", database=" + this.getDatabase() + ", schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ", serverTimezone=" + this.getServerTimezone() + ", allMigration=" + this.isAllMigration() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    public SqlServerSourceDTO() {
    }

    public SqlServerSourceDTO(String username, String password, String hostname, int port, String database, String schemaName, String tableName, String serverTimezone, boolean allMigration, String primaryKey) {
        this.username = username;
        this.password = password;
        this.hostname = hostname;
        this.port = port;
        this.database = database;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.serverTimezone = serverTimezone;
        this.allMigration = allMigration;
        this.primaryKey = primaryKey;
    }

    public static class SqlServerSourceDTOBuilder {
        private String username;
        private String password;
        private String hostname;
        private int port;
        private String database;
        private String schemaName;
        private String tableName;
        private String serverTimezone;
        private boolean allMigration;
        private String primaryKey;

        SqlServerSourceDTOBuilder() {
        }

        public SqlServerSourceDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public SqlServerSourceDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public SqlServerSourceDTOBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public SqlServerSourceDTOBuilder port(int port) {
            this.port = port;
            return this;
        }

        public SqlServerSourceDTOBuilder database(String database) {
            this.database = database;
            return this;
        }

        public SqlServerSourceDTOBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public SqlServerSourceDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public SqlServerSourceDTOBuilder serverTimezone(String serverTimezone) {
            this.serverTimezone = serverTimezone;
            return this;
        }

        public SqlServerSourceDTOBuilder allMigration(boolean allMigration) {
            this.allMigration = allMigration;
            return this;
        }

        public SqlServerSourceDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public SqlServerSourceDTO build() {
            return new SqlServerSourceDTO(this.username, this.password, this.hostname, this.port, this.database, this.schemaName, this.tableName, this.serverTimezone, this.allMigration, this.primaryKey);
        }

        public String toString() {
            return "SqlServerSourceDTO.SqlServerSourceDTOBuilder(username=" + this.username + ", password=" + this.password + ", hostname=" + this.hostname + ", port=" + this.port + ", database=" + this.database + ", schemaName=" + this.schemaName + ", tableName=" + this.tableName + ", serverTimezone=" + this.serverTimezone + ", allMigration=" + this.allMigration + ", primaryKey=" + this.primaryKey + ")";
        }
    }
}

