/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.stream;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.inlong.manager.common.pojo.stream.StreamField;
import org.apache.inlong.manager.common.util.Preconditions;

public class StreamNode {
    protected Set<String> preNodes;
    protected Set<String> postNodes;
    protected List<StreamField> fieldList;

    public void addPre(String pre) {
        Preconditions.checkNotEmpty(pre, "Pre node should not be empty");
        if (this.preNodes == null) {
            this.preNodes = Sets.newHashSet();
        }
        this.preNodes.add(pre);
    }

    public void addPost(String post) {
        Preconditions.checkNotEmpty(post, "Post node should not be empty");
        if (this.postNodes == null) {
            this.postNodes = Sets.newHashSet();
        }
        this.postNodes.add(post);
    }

    protected StreamNode(StreamNodeBuilder<?, ?> b) {
        this.preNodes = ((StreamNodeBuilder)b).preNodes;
        this.postNodes = ((StreamNodeBuilder)b).postNodes;
        this.fieldList = ((StreamNodeBuilder)b).fieldList;
    }

    public static StreamNodeBuilder<?, ?> builder() {
        return new StreamNodeBuilderImpl();
    }

    public Set<String> getPreNodes() {
        return this.preNodes;
    }

    public Set<String> getPostNodes() {
        return this.postNodes;
    }

    public List<StreamField> getFieldList() {
        return this.fieldList;
    }

    public void setPreNodes(Set<String> preNodes) {
        this.preNodes = preNodes;
    }

    public void setPostNodes(Set<String> postNodes) {
        this.postNodes = postNodes;
    }

    public void setFieldList(List<StreamField> fieldList) {
        this.fieldList = fieldList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamNode)) {
            return false;
        }
        StreamNode other = (StreamNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$preNodes = this.getPreNodes();
        Set<String> other$preNodes = other.getPreNodes();
        if (this$preNodes == null ? other$preNodes != null : !((Object)this$preNodes).equals(other$preNodes)) {
            return false;
        }
        Set<String> this$postNodes = this.getPostNodes();
        Set<String> other$postNodes = other.getPostNodes();
        if (this$postNodes == null ? other$postNodes != null : !((Object)this$postNodes).equals(other$postNodes)) {
            return false;
        }
        List<StreamField> this$fieldList = this.getFieldList();
        List<StreamField> other$fieldList = other.getFieldList();
        return !(this$fieldList == null ? other$fieldList != null : !((Object)this$fieldList).equals(other$fieldList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StreamNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $preNodes = this.getPreNodes();
        result = result * 59 + ($preNodes == null ? 43 : ((Object)$preNodes).hashCode());
        Set<String> $postNodes = this.getPostNodes();
        result = result * 59 + ($postNodes == null ? 43 : ((Object)$postNodes).hashCode());
        List<StreamField> $fieldList = this.getFieldList();
        result = result * 59 + ($fieldList == null ? 43 : ((Object)$fieldList).hashCode());
        return result;
    }

    public String toString() {
        return "StreamNode(preNodes=" + this.getPreNodes() + ", postNodes=" + this.getPostNodes() + ", fieldList=" + this.getFieldList() + ")";
    }

    public StreamNode() {
    }

    public StreamNode(Set<String> preNodes, Set<String> postNodes, List<StreamField> fieldList) {
        this.preNodes = preNodes;
        this.postNodes = postNodes;
        this.fieldList = fieldList;
    }

    private static final class StreamNodeBuilderImpl
    extends StreamNodeBuilder<StreamNode, StreamNodeBuilderImpl> {
        private StreamNodeBuilderImpl() {
        }

        @Override
        protected StreamNodeBuilderImpl self() {
            return this;
        }

        @Override
        public StreamNode build() {
            return new StreamNode(this);
        }
    }

    public static abstract class StreamNodeBuilder<C extends StreamNode, B extends StreamNodeBuilder<C, B>> {
        private Set<String> preNodes;
        private Set<String> postNodes;
        private List<StreamField> fieldList;

        protected abstract B self();

        public abstract C build();

        public B preNodes(Set<String> preNodes) {
            this.preNodes = preNodes;
            return this.self();
        }

        public B postNodes(Set<String> postNodes) {
            this.postNodes = postNodes;
            return this.self();
        }

        public B fieldList(List<StreamField> fieldList) {
            this.fieldList = fieldList;
            return this.self();
        }

        public String toString() {
            return "StreamNode.StreamNodeBuilder(preNodes=" + this.preNodes + ", postNodes=" + this.postNodes + ", fieldList=" + this.fieldList + ")";
        }
    }
}

