/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.pojo.transform.joiner;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import org.apache.inlong.manager.common.enums.TransformType;
import org.apache.inlong.manager.common.pojo.stream.StreamField;
import org.apache.inlong.manager.common.pojo.stream.StreamNode;
import org.apache.inlong.manager.common.pojo.transform.TransformDefinition;

public class JoinerDefinition
extends TransformDefinition {
    private StreamNode leftNode;
    private StreamNode rightNode;
    private List<StreamField> leftJoinFields;
    private List<StreamField> rightJoinFields;
    private JoinMode joinMode;

    public JoinerDefinition(StreamNode leftNode, StreamNode rightNode, List<StreamField> leftJoinFields, List<StreamField> rightJoinFields, JoinMode joinMode) {
        this.transformType = TransformType.JOINER;
        this.leftNode = leftNode;
        this.rightNode = rightNode;
        this.leftJoinFields = leftJoinFields;
        this.rightJoinFields = rightJoinFields;
        this.joinMode = joinMode;
    }

    public static JoinerDefinitionBuilder builder() {
        return new JoinerDefinitionBuilder();
    }

    public StreamNode getLeftNode() {
        return this.leftNode;
    }

    public StreamNode getRightNode() {
        return this.rightNode;
    }

    public List<StreamField> getLeftJoinFields() {
        return this.leftJoinFields;
    }

    public List<StreamField> getRightJoinFields() {
        return this.rightJoinFields;
    }

    public JoinMode getJoinMode() {
        return this.joinMode;
    }

    public void setLeftNode(StreamNode leftNode) {
        this.leftNode = leftNode;
    }

    public void setRightNode(StreamNode rightNode) {
        this.rightNode = rightNode;
    }

    public void setLeftJoinFields(List<StreamField> leftJoinFields) {
        this.leftJoinFields = leftJoinFields;
    }

    public void setRightJoinFields(List<StreamField> rightJoinFields) {
        this.rightJoinFields = rightJoinFields;
    }

    public void setJoinMode(JoinMode joinMode) {
        this.joinMode = joinMode;
    }

    @Override
    public String toString() {
        return "JoinerDefinition(leftNode=" + this.getLeftNode() + ", rightNode=" + this.getRightNode() + ", leftJoinFields=" + this.getLeftJoinFields() + ", rightJoinFields=" + this.getRightJoinFields() + ", joinMode=" + (Object)((Object)this.getJoinMode()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinerDefinition)) {
            return false;
        }
        JoinerDefinition other = (JoinerDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StreamNode this$leftNode = this.getLeftNode();
        StreamNode other$leftNode = other.getLeftNode();
        if (this$leftNode == null ? other$leftNode != null : !((Object)this$leftNode).equals(other$leftNode)) {
            return false;
        }
        StreamNode this$rightNode = this.getRightNode();
        StreamNode other$rightNode = other.getRightNode();
        if (this$rightNode == null ? other$rightNode != null : !((Object)this$rightNode).equals(other$rightNode)) {
            return false;
        }
        List<StreamField> this$leftJoinFields = this.getLeftJoinFields();
        List<StreamField> other$leftJoinFields = other.getLeftJoinFields();
        if (this$leftJoinFields == null ? other$leftJoinFields != null : !((Object)this$leftJoinFields).equals(other$leftJoinFields)) {
            return false;
        }
        List<StreamField> this$rightJoinFields = this.getRightJoinFields();
        List<StreamField> other$rightJoinFields = other.getRightJoinFields();
        if (this$rightJoinFields == null ? other$rightJoinFields != null : !((Object)this$rightJoinFields).equals(other$rightJoinFields)) {
            return false;
        }
        JoinMode this$joinMode = this.getJoinMode();
        JoinMode other$joinMode = other.getJoinMode();
        return !(this$joinMode == null ? other$joinMode != null : !((Object)((Object)this$joinMode)).equals((Object)other$joinMode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof JoinerDefinition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        StreamNode $leftNode = this.getLeftNode();
        result = result * 59 + ($leftNode == null ? 43 : ((Object)$leftNode).hashCode());
        StreamNode $rightNode = this.getRightNode();
        result = result * 59 + ($rightNode == null ? 43 : ((Object)$rightNode).hashCode());
        List<StreamField> $leftJoinFields = this.getLeftJoinFields();
        result = result * 59 + ($leftJoinFields == null ? 43 : ((Object)$leftJoinFields).hashCode());
        List<StreamField> $rightJoinFields = this.getRightJoinFields();
        result = result * 59 + ($rightJoinFields == null ? 43 : ((Object)$rightJoinFields).hashCode());
        JoinMode $joinMode = this.getJoinMode();
        result = result * 59 + ($joinMode == null ? 43 : ((Object)((Object)$joinMode)).hashCode());
        return result;
    }

    public static class JoinerDefinitionBuilder {
        private StreamNode leftNode;
        private StreamNode rightNode;
        private List<StreamField> leftJoinFields;
        private List<StreamField> rightJoinFields;
        private JoinMode joinMode;

        JoinerDefinitionBuilder() {
        }

        public JoinerDefinitionBuilder leftNode(StreamNode leftNode) {
            this.leftNode = leftNode;
            return this;
        }

        public JoinerDefinitionBuilder rightNode(StreamNode rightNode) {
            this.rightNode = rightNode;
            return this;
        }

        public JoinerDefinitionBuilder leftJoinFields(List<StreamField> leftJoinFields) {
            this.leftJoinFields = leftJoinFields;
            return this;
        }

        public JoinerDefinitionBuilder rightJoinFields(List<StreamField> rightJoinFields) {
            this.rightJoinFields = rightJoinFields;
            return this;
        }

        public JoinerDefinitionBuilder joinMode(JoinMode joinMode) {
            this.joinMode = joinMode;
            return this;
        }

        public JoinerDefinition build() {
            return new JoinerDefinition(this.leftNode, this.rightNode, this.leftJoinFields, this.rightJoinFields, this.joinMode);
        }

        public String toString() {
            return "JoinerDefinition.JoinerDefinitionBuilder(leftNode=" + this.leftNode + ", rightNode=" + this.rightNode + ", leftJoinFields=" + this.leftJoinFields + ", rightJoinFields=" + this.rightJoinFields + ", joinMode=" + (Object)((Object)this.joinMode) + ")";
        }
    }

    @JsonFormat
    public static enum JoinMode {
        LEFT_JOIN,
        RIGHT_JOIN,
        INNER_JOIN;

    }
}

