/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.util;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;

public class CommonBeanUtils
extends BeanUtils {
    public static <S, T> List<T> copyListProperties(List<S> sources, Supplier<T> target) {
        if (sources == null || sources.isEmpty()) {
            return new ArrayList(0);
        }
        ArrayList<T> list = new ArrayList<T>(sources.size());
        for (S source : sources) {
            T t = target.get();
            CommonBeanUtils.copyProperties(source, t);
            list.add(t);
        }
        return list;
    }

    public static <S, T> T copyProperties(S source, Supplier<T> target) {
        T result = target.get();
        if (source == null) {
            return result;
        }
        CommonBeanUtils.copyProperties(source, result);
        return result;
    }

    public static <S, T> T copyProperties(S source, T target, boolean ignoreNull) {
        if (source == null) {
            return target;
        }
        if (ignoreNull) {
            CommonBeanUtils.copyProperties(source, target, (String[])CommonBeanUtils.getNullPropertyNames(source));
        } else {
            CommonBeanUtils.copyProperties(source, target);
        }
        return target;
    }

    public static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }
}

