/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    private static final Logger log = LoggerFactory.getLogger(NetworkUtils.class);

    public static String getClientIpAddress(HttpServletRequest request) {
        String realIp = request.getHeader("X-Real-IP");
        if (StringUtils.isBlank((CharSequence)realIp) || "unknown".equalsIgnoreCase(realIp)) {
            realIp = request.getHeader("X-Forwarded-For");
        }
        if (StringUtils.isBlank((CharSequence)realIp) || "unknown".equalsIgnoreCase(realIp)) {
            realIp = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)realIp) || "unknown".equalsIgnoreCase(realIp)) {
            realIp = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((CharSequence)realIp) || "unknown".equalsIgnoreCase(realIp)) {
            realIp = request.getRemoteAddr();
        }
        if (realIp != null && realIp.length() > 15 && realIp.indexOf(",") > 0) {
            realIp = realIp.substring(0, realIp.indexOf(","));
        }
        return realIp;
    }

    public static String getLocalIp() {
        InetAddress localHost = null;
        try {
            localHost = Inet4Address.getLocalHost();
            return localHost.getHostAddress();
        }
        catch (UnknownHostException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

