/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.util;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public class Preconditions {
    public static void checkNotNull(Object obj, String errMsg) {
        Preconditions.checkTrue(obj != null, errMsg);
    }

    public static void checkNotNull(Object obj, Supplier<String> errMsg) {
        Preconditions.checkTrue(obj != null, errMsg);
    }

    public static void checkNull(Object obj, String errMsg) {
        Preconditions.checkTrue(obj == null, errMsg);
    }

    public static void checkNull(Object obj, Supplier<String> errMsg) {
        Preconditions.checkTrue(obj == null, errMsg);
    }

    public static void checkEmpty(String str, String errMsg) {
        Preconditions.checkTrue(str == null || str.isEmpty(), errMsg);
    }

    public static void checkEmpty(String str, Supplier<String> errMsg) {
        Preconditions.checkTrue(str == null || str.isEmpty(), errMsg);
    }

    public static void checkEmpty(Collection<?> str, String errMsg) {
        Preconditions.checkTrue(str == null || str.isEmpty(), errMsg);
    }

    public static void checkEmpty(Collection<?> collection, Supplier<String> errMsg) {
        Preconditions.checkTrue(collection == null || collection.isEmpty(), errMsg);
    }

    public static void checkEmpty(Map<?, ?> map, String errMsg) {
        Preconditions.checkTrue(map == null || map.isEmpty(), errMsg);
    }

    public static void checkEmpty(Map<?, ?> map, Supplier<String> errMsg) {
        Preconditions.checkTrue(map == null || map.isEmpty(), errMsg);
    }

    public static void checkNotEmpty(String str, String errMsg) {
        Preconditions.checkTrue(str != null && !str.isEmpty(), errMsg);
    }

    public static void checkNotEmpty(String str, Supplier<String> errMsg) {
        Preconditions.checkTrue(str != null && !str.isEmpty(), errMsg);
    }

    public static void checkNotEmpty(Collection<?> collection, String errMsg) {
        Preconditions.checkTrue(collection != null && !collection.isEmpty(), errMsg);
    }

    public static void checkNotEmpty(Collection<?> collection, Supplier<String> errMsg) {
        Preconditions.checkTrue(collection != null && !collection.isEmpty(), errMsg);
    }

    public static void checkNotEmpty(Map<?, ?> map, String errMsg) {
        Preconditions.checkTrue(map != null && !map.isEmpty(), errMsg);
    }

    public static void checkNotEmpty(Map<?, ?> map, Supplier<String> errMsg) {
        Preconditions.checkTrue(map != null && !map.isEmpty(), errMsg);
    }

    public static void checkFalse(boolean condition, String errMsg) {
        Preconditions.checkTrue(!condition, errMsg);
    }

    public static void checkFalse(boolean condition, Supplier<String> errMsg) {
        Preconditions.checkTrue(!condition, errMsg);
    }

    public static void checkTrue(boolean condition, Supplier<String> errMsg) {
        if (!condition) {
            throw new IllegalArgumentException(errMsg.get());
        }
    }

    public static void checkTrue(boolean condition, String errMsg) {
        if (!condition) {
            throw new IllegalArgumentException(errMsg);
        }
    }
}

