/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmallTools {
    private static final Logger log = LoggerFactory.getLogger(SmallTools.class);
    private static final Pattern LOWER_NUMBER_PATTERN = Pattern.compile("^(?![0-9]+$)[a-z][a-z0-9_-]{1,200}$");
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static boolean isLowerOrNum(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            return LOWER_NUMBER_PATTERN.matcher(str).matches();
        }
        return false;
    }

    public static boolean ipCheck(String text) {
        if (text != null && !text.isEmpty()) {
            String regex = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
            return text.matches(regex);
        }
        return false;
    }

    public static boolean portCheck(int port) {
        return port > 0 && port < 65535;
    }

    public static String getMD5String(String source) {
        if (source == null) {
            return null;
        }
        String retString = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(source.getBytes(), 0, source.length());
            byte[] retBytes = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : retBytes) {
                sb.append(hexDigits[b >> 4 & 0xF]);
                sb.append(hexDigits[b & 0xF]);
            }
            retString = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("" + e);
        }
        return retString;
    }

    public static String passwordMd5(String password) {
        return new SimpleHash("MD5", (Object)password, null, 1024).toHex();
    }

    public static Date getOverDueDate(Integer validDays) {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, validDays);
        return cal.getTime();
    }

    public static Integer getValidDays(Date createDate, Date dueDate) {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate createLocalDate = createDate.toInstant().atZone(zoneId).toLocalDate();
        LocalDate dueLocalDate = dueDate.toInstant().atZone(zoneId).toLocalDate();
        return Math.toIntExact(dueLocalDate.toEpochDay() - createLocalDate.toEpochDay());
    }
}

