/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.auth;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.inlong.manager.common.auth.Authentication;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.common.util.Preconditions;

@JsonTypeDefine(value="token")
public class TokenAuthentication
implements Authentication {
    public static final String TOKEN = "token";
    protected String token;

    public TokenAuthentication(String token) {
        this.token = token;
    }

    @Override
    public Authentication.AuthType getAuthType() {
        return Authentication.AuthType.TOKEN;
    }

    @Override
    public void configure(Map<String, String> properties) {
        Preconditions.checkNotEmpty(properties, "Properties cannot be empty when init TokenAuthentication");
        this.token = properties.get(TOKEN);
    }

    public String toString() {
        ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
        objectNode.put(TOKEN, this.getToken());
        return objectNode.toString();
    }

    public TokenAuthentication() {
    }

    public String getToken() {
        return this.token;
    }
}

