/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.enums;

public enum DataSeparator {
    VERTICAL_BAR("|", 124),
    COMMA(",", 44),
    COLON(":", 58),
    SEMICOLON(";", 59),
    DASH("-", 45),
    SOH("\u0001", 1),
    STX("\u0002", 2),
    ETX("\u0003", 3);

    private final String separator;
    private final Integer asciiCode;

    private DataSeparator(String separator, int asciiCode) {
        this.asciiCode = asciiCode;
        this.separator = separator;
    }

    public static DataSeparator forAscii(int asciiCode) {
        for (DataSeparator value : DataSeparator.values()) {
            if (value.getAsciiCode() != asciiCode) continue;
            return value;
        }
        throw new IllegalArgumentException(String.format("Unsupported ascii for %s", asciiCode));
    }

    public String getSeparator() {
        return this.separator;
    }

    public Integer getAsciiCode() {
        return this.asciiCode;
    }
}

