/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtils {
    private static final Logger log = LoggerFactory.getLogger(AESUtils.class);
    private static final int DEFAULT_VERSION = 1;
    private static final int KEY_SIZE = 128;
    private static final String ALGORITHM = "AES";
    private static final String RNG_ALGORITHM = "SHA1PRNG";
    private static final String CONFIG_FILE = "application.properties";
    private static final String CONFIG_ITEM_ENCRYPT_KEY_PREFIX = "inlong.encrypt.key.value";
    private static final String CONFIG_ITEM_ENCRYPT_VERSION = "inlong.encrypt.version";
    public static Map<Integer, String> AES_KEY_MAP = new ConcurrentHashMap<Integer, String>();
    public static Integer CURRENT_VERSION;

    private static Properties getApplicationProperties() throws IOException {
        Properties properties = new Properties();
        String path = Thread.currentThread().getContextClassLoader().getResource("").getPath() + CONFIG_FILE;
        BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]));
        properties.load(inputStream);
        return properties;
    }

    public static Integer getCurrentVersion(Properties properties) throws IOException {
        String verStr;
        if (CURRENT_VERSION != null) {
            return CURRENT_VERSION;
        }
        if (properties == null) {
            properties = AESUtils.getApplicationProperties();
        }
        CURRENT_VERSION = StringUtils.isNotEmpty((CharSequence)(verStr = properties.getProperty(CONFIG_ITEM_ENCRYPT_VERSION))) ? Integer.valueOf(verStr) : Integer.valueOf(1);
        log.debug("Crypto CURRENT_VERSION = {}", (Object)CURRENT_VERSION);
        return CURRENT_VERSION;
    }

    public static String getAesKeyByConfig(Integer version) throws Exception {
        Integer targetVersion;
        Properties properties = AESUtils.getApplicationProperties();
        Integer n = targetVersion = version == null ? AESUtils.getCurrentVersion(properties) : version;
        if (StringUtils.isNotEmpty((CharSequence)AES_KEY_MAP.get(targetVersion))) {
            return AES_KEY_MAP.get(targetVersion);
        }
        String keyName = CONFIG_ITEM_ENCRYPT_KEY_PREFIX + targetVersion;
        String aesKey = properties.getProperty(keyName);
        if (StringUtils.isEmpty((CharSequence)aesKey)) {
            throw new RuntimeException(String.format("cannot find encryption key %s in application config", keyName));
        }
        AES_KEY_MAP.put(targetVersion, aesKey);
        return aesKey;
    }

    private static SecretKey generateKey(byte[] aesKey) throws Exception {
        SecureRandom random = SecureRandom.getInstance(RNG_ALGORITHM);
        random.setSeed(aesKey);
        KeyGenerator gen = KeyGenerator.getInstance(ALGORITHM);
        gen.init(128, random);
        return gen.generateKey();
    }

    public static byte[] encrypt(byte[] plainBytes, byte[] key) throws Exception {
        SecretKey secKey = AESUtils.generateKey(key);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, secKey);
        return cipher.doFinal(plainBytes);
    }

    public static String encryptToString(byte[] plainBytes, Integer version) throws Exception {
        if (version == null) {
            return new String(plainBytes, StandardCharsets.UTF_8);
        }
        byte[] keyBytes = AESUtils.getAesKeyByConfig(version).getBytes(StandardCharsets.UTF_8);
        return AESUtils.parseByte2HexStr(AESUtils.encrypt(plainBytes, keyBytes));
    }

    public static byte[] decrypt(byte[] cipherBytes, byte[] key) throws Exception {
        SecretKey secKey = AESUtils.generateKey(key);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, secKey);
        return cipher.doFinal(cipherBytes);
    }

    public static byte[] decryptAsString(String cipherText, Integer version) throws Exception {
        if (version == null) {
            return cipherText.getBytes(StandardCharsets.UTF_8);
        }
        byte[] keyBytes = AESUtils.getAesKeyByConfig(version).getBytes(StandardCharsets.UTF_8);
        return AESUtils.decrypt(AESUtils.parseHexStr2Byte(cipherText), keyBytes);
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuilder strBuf = new StringBuilder();
        for (byte b : buf) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            strBuf.append(hex.toUpperCase());
        }
        return strBuf.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

