/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SHAUtils {
    private static final Logger log = LoggerFactory.getLogger(SHAUtils.class);
    public static final String ALGORITHM_NAME = "SHA-256";
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String getSHAString(String source) {
        if (source == null) {
            return null;
        }
        String retString = null;
        try {
            MessageDigest md = MessageDigest.getInstance(ALGORITHM_NAME);
            md.update(source.getBytes(), 0, source.length());
            byte[] retBytes = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : retBytes) {
                sb.append(hexDigits[b >> 4 & 0xF]);
                sb.append(hexDigits[b & 0xF]);
            }
            retString = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("" + e);
        }
        return retString;
    }

    public static String encrypt(String source) {
        return new SimpleHash(ALGORITHM_NAME, (Object)source, null, 1024).toHex();
    }

    private SHAUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

