/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.auth;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.inlong.manager.common.auth.Authentication;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;

@JsonTypeDefine(value="default")
public class DefaultAuthentication
implements Authentication {
    public static final String DEFAULT = "default";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    protected String username;
    protected String password;

    public DefaultAuthentication(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public Authentication.AuthType getAuthType() {
        return Authentication.AuthType.UNAME_PASSWD;
    }

    @Override
    public void configure(Map<String, String> properties) {
        Preconditions.checkNotEmpty(properties, "Properties cannot be empty when init DefaultAuthentication");
        this.username = properties.get(USERNAME);
        this.password = properties.get(PASSWORD);
    }

    public String toString() {
        ObjectNode objectNode = JsonUtils.OBJECT_MAPPER.createObjectNode();
        objectNode.put(USERNAME, this.getUsername());
        objectNode.put(PASSWORD, this.getPassword());
        return objectNode.toString();
    }

    public DefaultAuthentication() {
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

