/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.util;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.exceptions.JsonException;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtils {
    private static final Logger log = LoggerFactory.getLogger(JsonUtils.class);
    public static final String PROJECT_PACKAGE = "org.apache.inlong.manager";
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String toJsonString(Object object) {
        return OBJECT_MAPPER.writeValueAsString(object);
    }

    public static String toPrettyJsonString(Object object) {
        return OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(object);
    }

    public static byte[] toJsonByte(Object object) {
        return OBJECT_MAPPER.writeValueAsBytes(object);
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(text, clazz);
        }
        catch (IOException e) {
            log.error("json parse err for: " + text, (Throwable)e);
            throw new JsonException(e);
        }
    }

    public static <T> T parseObject(byte[] bytes, Class<T> clazz) {
        if (ArrayUtils.isEmpty((byte[])bytes)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(bytes, clazz);
        }
        catch (IOException e) {
            log.error("json parse err for: " + Arrays.toString(bytes), (Throwable)e);
            throw new JsonException(e);
        }
    }

    public static <T> T parseObject(String text, JavaType javaType) {
        try {
            return (T)OBJECT_MAPPER.readValue(text, javaType);
        }
        catch (IOException e) {
            log.error("json parse err for: " + text, (Throwable)e);
            throw new JsonException(e);
        }
    }

    public static <T> T parseObject(String text, TypeReference<T> typeReference) {
        try {
            return (T)OBJECT_MAPPER.readValue(text, typeReference);
        }
        catch (IOException e) {
            log.error("json parse err for: " + text, (Throwable)e);
            throw new JsonException(e);
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return new ArrayList();
        }
        try {
            return (List)OBJECT_MAPPER.readValue(text, (JavaType)OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, clazz));
        }
        catch (IOException e) {
            log.error("json parse err for: " + text, (Throwable)e);
            throw new JsonException(e);
        }
    }

    public static JsonNode parseTree(String text) {
        try {
            return OBJECT_MAPPER.readTree(text);
        }
        catch (IOException e) {
            log.error("json parse err for: " + text, (Throwable)e);
            throw new JsonException(e);
        }
    }

    public static JsonNode parseTree(byte[] text) {
        try {
            return OBJECT_MAPPER.readTree(text);
        }
        catch (IOException e) {
            log.error("json parse err for: " + Arrays.toString(text), (Throwable)e);
            throw new JsonException(e);
        }
    }

    public static void initJsonTypeDefine(ObjectMapper objectMapper) {
        Reflections reflections = new Reflections(PROJECT_PACKAGE, new Scanner[0]);
        Set typeSet = reflections.getTypesAnnotatedWith(JsonTypeInfo.class);
        for (Class type : typeSet) {
            Set clazzSet = reflections.getSubTypesOf(type);
            if (CollectionUtils.isEmpty((Collection)clazzSet)) continue;
            clazzSet.stream().map(obj -> (Class)obj).filter(clazz -> !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())).forEach(clazz -> {
                JsonTypeDefine extendClassDefine = clazz.getAnnotation(JsonTypeDefine.class);
                if (extendClassDefine == null) {
                    return;
                }
                objectMapper.registerSubtypes(new NamedType[]{new NamedType(clazz, extendClassDefine.value())});
            });
        }
    }

    private JsonUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JsonUtils.initJsonTypeDefine(OBJECT_MAPPER);
    }
}

