/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.manager.common.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final Gson GSON = new GsonBuilder().create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean checkConnectivity(String host, int port, int connectTimeout, TimeUnit timeUnit) {
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        Socket socket = new Socket();
        socket.connect(socketAddress, (int)timeUnit.toMillis(connectTimeout));
        boolean bl = socket.isConnected();
        try {
            socket.close();
        }
        catch (IOException e) {
            log.warn("close connection from {}:{} failed", new Object[]{host, port, e});
        }
        return bl;
        catch (IOException e) {
            boolean bl2;
            try {
                log.error(String.format("%s:%s connected failed with err msg:%s", host, port, e.getMessage()));
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    socket.close();
                }
                catch (IOException e2) {
                    log.warn("close connection from {}:{} failed", new Object[]{host, port, e2});
                }
                throw throwable;
            }
            try {
                socket.close();
            }
            catch (IOException e3) {
                log.warn("close connection from {}:{} failed", new Object[]{host, port, e3});
            }
            return bl2;
        }
    }

    public static <T> T request(RestTemplate restTemplate, String url, HttpMethod method, String param, HttpHeaders header, Class<T> cls) throws Exception {
        try {
            HttpEntity request = new HttpEntity((Object)param, (MultiValueMap)header);
            log.debug("send request to {}, param {}", (Object)url, (Object)param);
            ResponseEntity exchange = restTemplate.exchange(url, method, request, String.class, new Object[0]);
            String body = (String)exchange.getBody();
            HttpStatus statusCode = exchange.getStatusCode();
            if (!statusCode.is2xxSuccessful()) {
                log.error("request error for {}, status code {}, body {}", new Object[]{url, statusCode, body});
            }
            log.debug("response from {}, status code {}", (Object)url, (Object)statusCode);
            return (T)GSON.fromJson((String)exchange.getBody(), cls);
        }
        catch (RestClientException e) {
            log.error("request for {} exception {} ", (Object)url, (Object)e.getMessage());
            throw e;
        }
    }

    public static <T> T request(RestTemplate restTemplate, String url, HttpMethod httpMethod, Object requestBody, HttpHeaders header, ParameterizedTypeReference<T> typeReference) {
        if (log.isDebugEnabled()) {
            log.debug("begin request to {} by request body {}", (Object)url, (Object)GSON.toJson(requestBody));
        }
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)header);
        ResponseEntity response = restTemplate.exchange(url, httpMethod, requestEntity, typeReference, new Object[0]);
        log.debug("success request to {}, status code {}", (Object)url, (Object)response.getStatusCode());
        Preconditions.expectTrue(response.getStatusCode().is2xxSuccessful(), "Request failed");
        return (T)response.getBody();
    }

    public static <T> T getRequest(RestTemplate restTemplate, String url, Map<String, Object> params, HttpHeaders header, ParameterizedTypeReference<T> typeReference) {
        return HttpUtils.request(restTemplate, HttpUtils.buildUrlWithQueryParam(url, params), HttpMethod.GET, null, header, typeReference);
    }

    public static <T> T putRequest(RestTemplate restTemplate, String url, Object params, HttpHeaders header, ParameterizedTypeReference<T> typeReference) {
        return HttpUtils.request(restTemplate, url, HttpMethod.PUT, params, header, typeReference);
    }

    public static <T> T postRequest(RestTemplate restTemplate, String url, Object params, HttpHeaders header, ParameterizedTypeReference<T> typeReference) {
        return HttpUtils.request(restTemplate, url, HttpMethod.POST, params, header, typeReference);
    }

    private static String buildUrlWithQueryParam(String url, Map<String, Object> params) {
        if (params == null) {
            return url;
        }
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
        params.entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> builder.queryParam((String)e.getKey(), new Object[]{e.getValue()}));
        return builder.build(false).toUriString();
    }
}

