/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.common.validation;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.inlong.manager.common.enums.IntListValuable;
import org.apache.inlong.manager.common.validation.InEnumInt;

public class InEnumIntValidator
implements ConstraintValidator<InEnumInt, Integer> {
    private List<Integer> values;

    public void initialize(InEnumInt annotation) {
        IntListValuable[] values = annotation.value().getEnumConstants();
        this.values = values.length == 0 ? Collections.emptyList() : values[0].valueList();
    }

    public boolean isValid(Integer value, ConstraintValidatorContext context) {
        if (value == null || this.values.contains(value)) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(context.getDefaultConstraintMessageTemplate().replace("{value}", Joiner.on((String)",").join(this.values))).addConstraintViolation();
        return false;
    }
}

